% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ollama.R
\name{chat}
\alias{chat}
\title{Chat with Ollama models}
\usage{
chat(
  model,
  messages,
  stream = FALSE,
  output = c("resp", "jsonlist", "raw", "df"),
  endpoint = "/api/chat"
)
}
\arguments{
\item{model}{A character string of the model name such as "llama3".}

\item{messages}{A list with list of messages for the model (see examples below).}

\item{stream}{Enable response streaming. Default is FALSE.}

\item{output}{The output format. Default is "resp". Other options are "jsonlist", "raw", "df".}

\item{endpoint}{The endpoint to chat with the model. Default is "/api/chat".}
}
\value{
A httr2 response object, json list, raw or data frame.
}
\description{
Chat with Ollama models
}
\examples{
\dontshow{if (test_connection()$status_code == 200) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# one message
messages <- list(
 list(role = "user", content = "How are you doing?")
)
chat("llama3", messages)
chat("llama3", messages, stream = TRUE)
chat("llama3", messages, stream = TRUE, output = "df")

# multiple messages
messages <- list(
 list(role = "user", content = "Hello!"),
 list(role = "assistant", content = "Hi! How are you?"),
 list(role = "user", content = "Who is the prime minister of the uk?"),
 list(role = "assistant", content = "Rishi Sunak"),
 list(role = "user", content = "List all the previous messages.")
)
chat("llama3", messages, stream = TRUE)
\dontshow{\}) # examplesIf}
}
