% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s4_get_basic_info_methods.R
\name{dim}
\alias{dim}
\alias{dim,ondisc_matrix-method}
\alias{dim,metadata_ondisc_matrix-method}
\alias{dim,multimodal_ondisc_matrix-method}
\alias{ncol}
\alias{nrow}
\alias{ncol,multimodal_ondisc_matrix-method}
\alias{nrow,multimodal_ondisc_matrix-method}
\title{Get dimension}
\usage{
\S4method{dim}{ondisc_matrix}(x)

\S4method{dim}{metadata_ondisc_matrix}(x)

\S4method{dim}{multimodal_ondisc_matrix}(x)

ncol(x)

nrow(x)

\S4method{ncol}{multimodal_ondisc_matrix}(x)

\S4method{nrow}{multimodal_ondisc_matrix}(x)
}
\arguments{
\item{x}{an \code{ondisc_matrix}, \code{metadata_ondisc_matrix}, or \code{multimodal_ondisc_matrix}.}
}
\value{
If \code{x} is an \code{ondisc_matrix} or \code{metadata_ondisc_matrix}, length-two integer vector containing
the dimension of \code{x}; if \code{x} is a \code{multimodal_ondisc_matrix}, a list of integer vectors containing the dimensions
of the constituent modalities of \code{x}.
}
\description{
Return the dimension of an \code{ondisc_matrix}, \code{metadata_ondisc_matrix}, or \code{multimodal_ondisc_matrix}.
}
\examples{
# NOTE: You must create the RDS files "expressions.rds" and
# "perturbations.rds" to run this example. Navigate to the help file of
# "create_ondisc_matrix_from_mtx" (via ?create_ondisc_matrix_from_mtx),
# and execute both code blocks.

# dimension of an ondisc_matrix
h5_fp <- paste0(tempdir(), "/expressions.h5")
if (file.exists(h5_fp)) {
odm <- ondisc_matrix(h5_file = h5_fp)
dim(odm)
}

# dimension of a metadata_ondic_matrix
expressions_fp <- paste0(tempdir(), "/expressions.rds")
if (file.exists(expressions_fp)) {
expressions <- readRDS(expressions_fp)
dim(expressions)
}

# dimension of a multimodal_ondisc_matrix
expression_fp <- paste0(tempdir(), "/expressions.rds")
perturbations_fp <- paste0(tempdir(), "/perturbations.rds")
if (file.exists(expression_fp) && file.exists(perturbations_fp)) {
    crispr_experiment <- multimodal_ondisc_matrix(list(expressions = readRDS(expression_fp),
    perturbations = readRDS(perturbations_fp)))
    dim(crispr_experiment)
}
}
