% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_heterogenous_pattern.R
\name{simulate_heterogenous_pattern}
\alias{simulate_heterogenous_pattern}
\title{simulate_heterogenous_pattern}
\usage{
simulate_heterogenous_pattern(x, nsim, fix_n = FALSE, ...)
}
\arguments{
\item{x}{ppp}

\item{nsim}{Number of patterns to simulate.}

\item{fix_n}{Logical if true the null model patterns have exactly the same number of points ais input.}

\item{...}{Arguments passed to \code{spatstat.core::density.ppp()}.}
}
\value{
list
}
\description{
Simulate heterogeneous pattern
}
\details{
Simulate heterogeneous point patterns as null model data for \code{spatstat.core::envelope()}.
A heterogeneous Poisson process is used, meaning that there are no interaction between points,
however, the simulated coordinates depend on the intensity \eqn{\lambda} of the input pattern.

Returns a \code{list} with \code{ppp} objects.
}
\examples{
set.seed(42)
input_pattern <- spatstat.core::rpoispp(lambda = function(x , y) {100 * exp(-3 * x)}, nsim = 1)
null_model <- simulate_heterogenous_pattern(input_pattern, nsim = 19)
spatstat.core::envelope(Y = input_pattern, fun = spatstat.core::pcf, nsim = 19,
simulate = null_model)

}
\references{
Baddeley, A., Rubak, E., Turner, R., 2015. Spatial point patterns: Methodology and
applications with R. Chapman and Hall/CRC Press, London.

Wiegand, T., Moloney, K.A., 2014. Handbook of spatial point-pattern analysis in
ecology. Chapman and Hall/CRC Press, Boca Raton.
}
\seealso{
\code{\link{envelope}} \cr
\code{\link{density.ppp}}
}
