% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{get_OBO}
\alias{get_OBO}
\title{Read ontology from OBO file into R}
\usage{
get_OBO(file, term_regexp = "^\\\\[(Term|Typedef)\\\\]",
  id = "^id: ([^ !]+).*", name = "^name: (\\\\.*)",
  parents = c("^is_a: ([^ !]+).*", "list"),
  obsolete = c("^is_obsolete: (true)", "logical"), remove_missing = FALSE,
  ...)
}
\arguments{
\item{file}{File path of obo file.}

\item{term_regexp}{Regular expression for which designates the beginning of the specification of a new term in the OBO file. See \code{\link{grep}} for details on formatting the expression.}

\item{id}{Regular expression for matching term IDs.}

\item{name}{Regular expression for matching human readable term labels.}

\item{parents}{Regular expression for matching against parents for each term.}

\item{obsolete}{Regular expression for extracting whether terms are obsolete.}

\item{remove_missing}{Logical value determining whether the parents in parent-child relationships in the ontology should be removed from the index. If there are parents which are missing, failure to remove them will lead to an error.}

\item{...}{Additional functions for extracting properties of individual nodes. Arguments should be named (such that the name of the argument becomes the name of the slot in the resulting \code{ontology_index} object), and character vectors of length 1 or 2: the first element being a regular expression, the second specifying the \code{"mode"} of the array to become the property in the returned index (see the \code{"mode"} argument of \code{\link{vector}} for more details).}
}
\value{
\code{ontology_index} object.
}
\description{
Read ontology from OBO file into R
}

