% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{check_projection}
\alias{check_projection}
\title{Show the projection of raster data and compare to the current GRASS location.}
\usage{
check_projection(path, format = "wkt")
}
\arguments{
\item{path}{character string vector; path raster data file(s)}

\item{format}{character string; how to format the output (see details)}
}
\value{
Nothing.
}
\description{
Check if the projection of raster files matches the region of the 
current location
}
\details{
This is a wrapper for the GRASS function
  \href{https://grass.osgeo.org/grass78/manuals/g.proj.html}{g.proj}. 
  It prints out the projection information of the current location
  and of the raster file(s). Based on this information it can be decided if the data 
  can be read into GRASS (\code{\link{import_data}}) without prior processing, i.e.
  if all raster data are of the same projection.
  Different output options can be chosen:
  * \code{wkt} WKT format (default)
  * \code{grass} conventional GRASS format
  * \code{shell} shell script style
  * \code{proj4} PROJ.4 format (note that this format is deprecated)
}
