% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ConvertData.r
\name{ConvertData}
\alias{ConvertData}
\title{Converting Input data with different coding scheme to standard format}
\usage{
ConvertData(input, yesLabel = NULL, noLabel = NULL, missLabel = NULL)
}
\arguments{
\item{input}{matrix input, the first column is ID, the rest of the columns each represent one symptom}

\item{yesLabel}{The value(s) coding "Yes" in the input matrix.}

\item{noLabel}{The value(s) coding "No" in the input matrix.}

\item{missLabel}{The value(s) coding "Missing" in the input matrix.}
}
\value{
a matrix with coding scheme as follows: "Y" for yes, "" for No, and "." for missing.
}
\description{
Converting Input data with different coding scheme to standard format
}
\examples{
\donttest{
# make up a fake 2 by 3 dataset with 2 deaths and 3 symptoms
id <- c("d1", "d2")
x <- matrix(c("Yes", "No", "Don't know",
			  "Yes", "Refused to answer", "No"),
			byrow = TRUE, nrow = 2, ncol = 3)
x <- cbind(id, x)
colnames(x) <- c("ID", "S1", "S2", "S3")
# see possible raw data (or existing data created for other purpose)
x
new <- ConvertData(x, yesLabel = "Yes", noLabel = "No",
			missLabel = c("Don't know", "Refused to answer"))
new
}
}

