% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pushgateway.R
\name{push_to_gateway}
\alias{push_to_gateway}
\alias{delete_from_gateway}
\title{Pushgateway Integration}
\usage{
push_to_gateway(url, job, instance = NA, registry = global_registry(), ...)

delete_from_gateway(url, job, instance = NA, ...)
}
\arguments{
\item{url}{The URL of the Pushgateway}

\item{job}{A value for the \code{job} label applied to all pushed metrics.}

\item{instance}{A value for the \code{instance} label applied to all pushed
metrics, or \code{NA} to leave it unset.}

\item{registry}{A \code{Registry} object, defaulting to the shared global one.}

\item{...}{Additional named string arguments converted to labels. Beware
that these are not yet checked for URL safety.}
}
\value{
\code{NULL}, invisibly.
}
\description{
Some workloads may not want to run an HTTP server to expose metrics,
especially in the case of short-lived batch jobs. For these cases metrics
can also be manually "pushed" to a Prometheus Pushgateway instance, though
\href{https://prometheus.io/docs/practices/pushing/}{there are drawbacks}.

\code{push_to_gateway()} is used to push metrics, and \code{delete_from_gateway()} is
used to clean them up when the workload is finished.
}
\examples{
\dontrun{
register_default_metrics()
push_to_gateway("localhost:9091", job = "batch-job-1")
# Some time later...
delete_from_gateway("localhost:9091", job = "batch-job-1")
}

}
