% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{ors_matrix}
\alias{ors_matrix}
\title{Openrouteservice Matrix}
\usage{
ors_matrix(
  locations,
  profile = ors_profile(),
  ...,
  api_key = ors_api_key(),
  output = c("parsed", "text")
)
}
\arguments{
\item{locations}{List of \verb{longitude, latitude} coordinate pairs, alternatively a two column \code{matrix} or \code{data.frame}.}

\item{profile}{Route profile, defaults to \code{"driving-car"}.}

\item{...}{Optional parameters as described \href{https://openrouteservice.org/dev/#/api-docs/v2/matrix/{profile}/post}{here}}

\item{api_key}{Character scalar containing openrouteservice API key}

\item{output}{Output format. By default the response is being parsed to a list-based R object}
}
\value{
Duration or distance matrix for multiple source and destination

\itemize{
\item for \code{"text"}, a character vector of length 1 re-encoded to UTF-8.
}

\itemize{
\item for \code{"parsed"}, a parsed R object.
}
}
\description{
Obtain one-to-many, many-to-one and many-to-many matrices for time and
distance.
}
\examples{
\donttest{coordinates <- list(
  c(9.970093, 48.477473),
  c(9.207916, 49.153868),
  c(37.573242, 55.801281),
  c(115.663757,38.106467)
)

# query for duration and distance in km
res <- ors_matrix(coordinates, metrics = c("duration", "distance"), units = "km")

# duration in hours
res$durations / 3600

# distance in km
res$distances}
}
\author{
Andrzej Oleś \href{mailto:andrzej.oles@gmail.com}{andrzej.oles@gmail.com}
}
