% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_get_base_font}
\alias{wb_get_base_font}
\title{Return the workbook default font}
\usage{
wb_get_base_font(wb)
}
\arguments{
\item{wb}{A \link{wbWorkbook} object}
}
\description{
Get the base font used in the workbook.
}
\examples{
## create a workbook
wb <- wb_workbook()
wb_get_base_font(wb)

## modify base font to size 10 Arial Narrow in red
wb$set_base_font(fontSize = 10, fontColour = "#FF0000", fontName = "Arial Narrow")

wb_get_base_font(wb)
}
\seealso{
Other workbook wrappers: 
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_creators}},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_save}()},
\code{\link{wb_set_col_widths}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_set_row_heights}()},
\code{\link{wb_workbook}()},
\code{\link{workbook_grouping}},
\code{\link{ws_cell_merge}}
}
\concept{workbook wrappers}
