% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_set_header_footer}
\alias{wb_set_header_footer}
\title{Set headers and footers of a worksheet}
\usage{
wb_set_header_footer(
  wb,
  sheet = current_sheet(),
  header = NULL,
  footer = NULL,
  even_header = NULL,
  even_footer = NULL,
  first_header = NULL,
  first_footer = NULL,
  ...
)
}
\arguments{
\item{wb}{A Workbook object}

\item{sheet}{A name or index of a worksheet}

\item{header, even_header, first_header, footer, even_footer, first_footer}{Character vector of length 3 corresponding to positions left, center,
right.  \code{header} and \code{footer} are used to default additional arguments.
Setting \code{even}, \code{odd}, or \code{first}, overrides \code{header}/\code{footer}. Use \code{NA} to
skip a position.}

\item{...}{additional arguments}
}
\description{
Set document headers and footers. You can also do this when adding a worksheet
with \code{\link[=wb_add_worksheet]{wb_add_worksheet()}} with the \code{header}, \code{footer} arguments and friends.
These will show up when printing an xlsx file.
}
\details{
Headers and footers can contain special tags
\itemize{
\item \strong{&[Page]} Page number
\item \strong{&[Pages]} Number of pages
\item \strong{&[Date]} Current date
\item \strong{&[Time]} Current time
\item \strong{&[Path]} File path
\item \strong{&[File]} File name
\item \strong{&[Tab]} Worksheet name
}
}
\examples{
wb <- wb_workbook()

# Add example data
wb$add_worksheet("S1")$add_data(x = 1:400)
wb$add_worksheet("S2")$add_data(x = 1:400)
wb$add_worksheet("S3")$add_data(x = 3:400)
wb$add_worksheet("S4")$add_data(x = 3:400)

wb$set_header_footer(
  sheet = "S1",
  header = c("ODD HEAD LEFT", "ODD HEAD CENTER", "ODD HEAD RIGHT"),
  footer = c("ODD FOOT RIGHT", "ODD FOOT CENTER", "ODD FOOT RIGHT"),
  even_header = c("EVEN HEAD LEFT", "EVEN HEAD CENTER", "EVEN HEAD RIGHT"),
  even_footer = c("EVEN FOOT RIGHT", "EVEN FOOT CENTER", "EVEN FOOT RIGHT"),
  first_header = c("TOP", "OF FIRST", "PAGE"),
  first_footer = c("BOTTOM", "OF FIRST", "PAGE")
)

wb$set_header_footer(
  sheet = 2,
  header = c("&[Date]", "ALL HEAD CENTER 2", "&[Page] / &[Pages]"),
  footer = c("&[Path]&[File]", NA, "&[Tab]"),
  first_header = c(NA, "Center Header of First Page", NA),
  first_footer = c(NA, "Center Footer of First Page", NA)
)

wb$set_header_footer(
  sheet = 3,
  header = c("ALL HEAD LEFT 2", "ALL HEAD CENTER 2", "ALL HEAD RIGHT 2"),
  footer = c("ALL FOOT RIGHT 2", "ALL FOOT CENTER 2", "ALL FOOT RIGHT 2")
)

wb$set_header_footer(
  sheet = 4,
  first_header = c("FIRST ONLY L", NA, "FIRST ONLY R"),
  first_footer = c("FIRST ONLY L", NA, "FIRST ONLY R")
)
}
