% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_pivot_table}
\alias{wb_add_pivot_table}
\title{Add a pivot table to a worksheet}
\usage{
wb_add_pivot_table(
  wb,
  x,
  sheet = next_sheet(),
  dims = "A3",
  filter,
  rows,
  cols,
  data,
  fun,
  params,
  pivot_table,
  slicer
)
}
\arguments{
\item{wb}{A Workbook object containing a #' worksheet.}

\item{x}{A \code{data.frame} that inherits the \code{\link[=wb_data]{wb_data}} class.}

\item{sheet}{A worksheet containing a #'}

\item{dims}{The worksheet cell where the pivot table is placed}

\item{filter}{The column name(s) of \code{x} used for filter.}

\item{rows}{The column name(s) of \code{x} used as rows}

\item{cols}{The column names(s) of \code{x} used as cols}

\item{data}{The column name(s) of \code{x} used as data}

\item{fun}{A vector of functions to be used with \code{data}}

\item{params}{A list of parameters to modify pivot table creation.}

\item{pivot_table}{An optional name for the pivot table}

\item{slicer}{a character object with names used as slicer}
}
\description{
Add a pivot table to a worksheet. The data must be specified using \code{\link[=wb_data]{wb_data()}}
to ensure the function works.
}
\details{
\code{fun} can be any of \code{AVERAGE}, \code{COUNT}, \code{COUNTA}, \code{MAX}, \code{MIN},
\code{PRODUCT}, \code{STDEV}, \code{STDEVP}, \code{SUM}, \code{VAR}, \code{VARP}.

\code{show_data_as} can be any of \code{normal}, \code{difference}, \code{percent}, \code{percentDiff},
\code{runTotal}, \code{percentOfRow}, \code{percentOfCol}, \code{percentOfTotal}, \code{index}.

The sheet will be empty unless it is opened in spreadsheet software.
}
\examples{
wb <- wb_workbook() \%>\% wb_add_worksheet() \%>\% wb_add_data(x = mtcars)

df <- wb_data(wb, sheet = 1)

wb <- wb \%>\%
  wb_add_pivot_table(df, dims = "A3",
    filter = "am", rows = "cyl", cols = "gear", data = "disp"
  )
}
\seealso{
\code{\link[=wb_data]{wb_data()}}

Other workbook wrappers: 
\code{\link{base_font-wb}},
\code{\link{col_widths-wb}},
\code{\link{creators-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_workbook}()}

Other worksheet content functions: 
\code{\link{col_widths-wb}},
\code{\link{filter-wb}},
\code{\link{grouping-wb}},
\code{\link{named_region-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_conditional_formatting}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_thread}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()}
}
\concept{workbook wrappers}
\concept{worksheet content functions}
