% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_set_grid_lines}
\alias{wb_set_grid_lines}
\alias{wb_grid_lines}
\title{Modify grid lines visibility in a worksheet}
\usage{
wb_set_grid_lines(wb, sheet = current_sheet(), show = FALSE, print = show)

wb_grid_lines(wb, sheet = current_sheet(), show = FALSE, print = show)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{show}{A logical. If \code{FALSE}, grid lines are hidden.}

\item{print}{A logical. If \code{FALSE}, grid lines are not printed.}
}
\description{
Set worksheet grid lines to show or hide.
You can also add / remove grid lines when creating a worksheet with
\code{\link[=wb_add_worksheet]{wb_add_worksheet(grid_lines = FALSE)}}
}
\examples{
wb <- wb_workbook()$add_worksheet()$add_worksheet()
wb$get_sheet_names() ## list worksheets in workbook
wb$set_grid_lines(1, show = FALSE)
wb$set_grid_lines("Sheet 2", show = FALSE)
}
