context("pounds")

test_that("pounds format", {
    expect_equal(pounds(c(100, 0.23, 1.456565, 2000)), c("\u00a3100.00", "\u00a30.23", "\u00a31.46", "\u00a32,000.00"))
    expect_equal(pounds(c(1:10 * 10)), c("\u00a310", "\u00a320", "\u00a330", "\u00a340", "\u00a350", "\u00a360", "\u00a370", "\u00a380", "\u00a390", "\u00a3100"))
    expect_equal(pounds((1:10 * 10) + 0.01), c("\u00a310.01", "\u00a320.01", "\u00a330.01", "\u00a340.01", "\u00a350.01", "\u00a360.01", "\u00a370.01", "\u00a380.01", "\u00a390.01", "\u00a3100.01"))
    expect_equal(pounds((1:10 * 10) + 0.001), c("\u00a310", "\u00a320", "\u00a330", "\u00a340", "\u00a350", "\u00a360", "\u00a370", "\u00a380", "\u00a390", "\u00a3100"))
    expect_equal(pounds(10^(1:8)), c("\u00a310", "\u00a3100", "\u00a31,000", "\u00a310,000", "\u00a3100,000", "\u00a31,000,000", "\u00a310,000,000", "\u00a3100,000,000"))
    expect_equal(pounds(seq(10111.11, 1e+05, 10111.11)), c("\u00a310,111.11", "\u00a320,222.22", "\u00a330,333.33", "\u00a340,444.44", "\u00a350,555.55", "\u00a360,666.66", "\u00a370,777.77", 
        "\u00a380,888.88", "\u00a390,999.99"))
    expect_equal(pounds(seq(101111.11, 1e+06, 101111.11)), c("\u00a3101,111", "\u00a3202,222", "\u00a3303,333", "\u00a3404,444", "\u00a3505,556", "\u00a3606,667", "\u00a3707,778", "\u00a3808,889", 
        "\u00a3910,000"))
    expect_equal(pounds(seq(101111, 1e+06, 101111)), c("\u00a3101,111", "\u00a3202,222", "\u00a3303,333", "\u00a3404,444", "\u00a3505,555", "\u00a3606,666", "\u00a3707,777", "\u00a3808,888", 
        "\u00a3909,999"))
    expect_equal(pounds(seq(10111111.11, 1e+08, 10111111.11)), c("\u00a310,111,111", "\u00a320,222,222", "\u00a330,333,333", "\u00a340,444,444", "\u00a350,555,556", "\u00a360,666,667", 
        "\u00a370,777,778", "\u00a380,888,889", "\u00a391,000,000"))
    expect_equal(pounds((1:10) * 1e+05), c("\u00a3100,000", "\u00a3200,000", "\u00a3300,000", "\u00a3400,000", "\u00a3500,000", "\u00a3600,000", "\u00a3700,000", "\u00a3800,000", "\u00a3900,000", 
        "\u00a31,000,000"))
    expect_equal(pounds(((1:10) * 1e+05) + 0.01), c("\u00a3100,000", "\u00a3200,000", "\u00a3300,000", "\u00a3400,000", "\u00a3500,000", "\u00a3600,000", "\u00a3700,000", "\u00a3800,000", "\u00a3900,000", 
        "\u00a31,000,000"))
    expect_equal(pounds(c(9.999)), c("\u00a310"))
    expect_equal(pounds(99.999), "\u00a3100")
}) 



test_that("pounds_format format", {
  expect_equal(pounds_format()(c(100, 0.23, 1.456565, 2000)), c("\u00a3100.00", "\u00a30.23", "\u00a31.46", "\u00a32,000.00"))
  expect_equal(pounds_format()(c(1:10 * 10)), c("\u00a310", "\u00a320", "\u00a330", "\u00a340", "\u00a350", "\u00a360", "\u00a370", "\u00a380", "\u00a390", "\u00a3100"))
  expect_equal(pounds_format()((1:10 * 10) + 0.01), c("\u00a310.01", "\u00a320.01", "\u00a330.01", "\u00a340.01", "\u00a350.01", "\u00a360.01", "\u00a370.01", "\u00a380.01", "\u00a390.01", "\u00a3100.01"))
  expect_equal(pounds_format()((1:10 * 10) + 0.001), c("\u00a310", "\u00a320", "\u00a330", "\u00a340", "\u00a350", "\u00a360", "\u00a370", "\u00a380", "\u00a390", "\u00a3100"))
  expect_equal(pounds_format()(10^(1:8)), c("\u00a310", "\u00a3100", "\u00a31,000", "\u00a310,000", "\u00a3100,000", "\u00a31,000,000", "\u00a310,000,000", "\u00a3100,000,000"))
  expect_equal(pounds_format()(seq(10111.11, 1e+05, 10111.11)), c("\u00a310,111.11", "\u00a320,222.22", "\u00a330,333.33", "\u00a340,444.44", "\u00a350,555.55", "\u00a360,666.66", "\u00a370,777.77", 
                                                         "\u00a380,888.88", "\u00a390,999.99"))
  expect_equal(pounds_format()(seq(101111.11, 1e+06, 101111.11)), c("\u00a3101,111", "\u00a3202,222", "\u00a3303,333", "\u00a3404,444", "\u00a3505,556", "\u00a3606,667", "\u00a3707,778", "\u00a3808,889", 
                                                           "\u00a3910,000"))
  expect_equal(pounds_format()(seq(101111, 1e+06, 101111)), c("\u00a3101,111", "\u00a3202,222", "\u00a3303,333", "\u00a3404,444", "\u00a3505,555", "\u00a3606,666", "\u00a3707,777", "\u00a3808,888", 
                                                     "\u00a3909,999"))
  expect_equal(pounds_format()(seq(10111111.11, 1e+08, 10111111.11)), c("\u00a310,111,111", "\u00a320,222,222", "\u00a330,333,333", "\u00a340,444,444", "\u00a350,555,556", "\u00a360,666,667", 
                                                               "\u00a370,777,778", "\u00a380,888,889", "\u00a391,000,000"))
  expect_equal(pounds_format()((1:10) * 1e+05), c("\u00a3100,000", "\u00a3200,000", "\u00a3300,000", "\u00a3400,000", "\u00a3500,000", "\u00a3600,000", "\u00a3700,000", "\u00a3800,000", "\u00a3900,000", 
                                         "\u00a31,000,000"))
  expect_equal(pounds_format()(((1:10) * 1e+05) + 0.01), c("\u00a3100,000", "\u00a3200,000", "\u00a3300,000", "\u00a3400,000", "\u00a3500,000", "\u00a3600,000", "\u00a3700,000", "\u00a3800,000", "\u00a3900,000", 
                                                  "\u00a31,000,000"))
  expect_equal(pounds_format()(c(9.999)), c("\u00a310"))
  expect_equal(pounds_format()(99.999), "\u00a3100")
}) 
