% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataPreparation.R
\name{dataPreparation}
\alias{dataPreparation}
\title{Transform data to the expected format}
\usage{
dataPreparation(dat, uncertainty = "SE", expVAL = "mean")
}
\arguments{
\item{dat}{Data frame or tibble in the format of the \code{\link{exampleData}}.}

\item{uncertainty}{Indicates the column name of the uncertainty in the data.
Typical is "SE" for standard
error or "SD" for standard deviation.}

\item{expVAL}{Indicates the column name of the expected value.}
}
\value{
A formatted coefficients table with land-use options and indicator values ready for initialization via \code{\link{initScenario}}.
}
\description{
The input data must suit to the specific expected optimLanduse format prior to
initialization and optimization. This function
provides the possibility to easily transform data from the commonly used form
of the exemplary data
\code{\link{exampleData}} into to the expected format. The application of this function
is not mandatory
if you want to transform your data yourself or if your data is not formatted as
the example data. The application example on the
\href{https://gitlab.gwdg.de/forest_economics_goettingen/optimlanduse}{GitLab project page}
provides information about the expected structure. Incomplete rows with NA-values are deleted and an error message is displayed.
}
\examples{
require(readxl)
dat <- read_xlsx(exampleData("exampleGosling_dataPrep.xlsx"), col_names = TRUE)
dat <- dataPreparation(dat, uncertainty = "sd", expVAL = "mean")
}
