% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quaisDimensoes.R
\name{whichMembers}
\alias{whichMembers}
\title{List of Members in a Brazilian Federal Budget Dimension.}
\usage{
whichMembers(
  exercicio = .last_year(),
  dimensao,
  ignoreSecureCertificate = FALSE
)
}
\arguments{
\item{exercicio}{A number. Indicates the year to which the extracted data refers.}

\item{dimensao}{A string. The dimension to be listed.
Valid values: [dimensoes]}

\item{ignoreSecureCertificate}{A Boolean. If the parameter is set to \code{TRUE},
the download of SIOP data will proceed while ignoring the secure certificate.
(Se o parâmetro estiver definido como \code{TRUE}, o download dos dados
do SIOP será realizado ignorando o certificado seguro.)}
}
\value{
The dataframe contains the members in a dimension. Both code and description are provided.
}
\description{
This function calls [quaisMembros].
}
\examples{
\dontrun{whichMembers(2023, dimensao = "Funcao")}

}
