% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ocm.methods.R
\name{extractAIC.ocm}
\alias{extractAIC.ocm}
\title{Extract AIC from a fitted Continuous Ordinal Model}
\usage{
\method{extractAIC}{ocm}(fit, scale = 0, k = 2, ...)
}
\arguments{
\item{fit}{\code{ocm} object}

\item{scale}{parameter currently not used. For compatibility with general extractAIC method.}

\item{k}{``weight'' of the equivalent degrees of freedom (=: edf)
in the AIC formula. Defaults to 2}

\item{...}{further arguments to be passed to methods}
}
\value{
A numeric vector of length 2, with first and second elements giving
\item{edf}{the ``equivalent degrees of freedom'' for the fitted model \code{fit}}
\item{AIC}{the generalized AIC of \code{ocm} object \code{fit}}
}
\description{
Extracts the AIC for a fitted \code{ocm} object
}
\details{
The generalized AIC is computed:
\deqn{-2\ell +k\cdot edf}
where \eqn{\ell} is the log likelihood, k=2 gives the AIC, and
k=log(n) gives the BIC.
}
\examples{
ANZ0001.ocm <- ANZ0001[ANZ0001$cycleno==0 | ANZ0001$cycleno==5,]
ANZ0001.ocm$cycleno[ANZ0001.ocm$cycleno==5] <- 1
fit.overall  <- ocm(overall  ~ cycleno + age + bsa + treatment, data=ANZ0001.ocm)
extractAIC(fit.overall)
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\references{
Akaike, H (1983).
Information measures and model selection,
\emph{Bulletin of the International Statistical Institute}, 50:277-290.
}
\seealso{
\code{\link{ocm}}, \code{\link{extractAIC.ocmm}}
}

