% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-isoline.r
\name{geom_isoline}
\alias{geom_isoline}
\title{Isolines (contour lines)}
\usage{
geom_isoline(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  isoline_text = TRUE,
  by = NULL,
  num = NULL,
  label_dodge = 0.03,
  ...,
  parse = FALSE,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{isoline_text}{Logical; whether to include text value marks along the
isolines.}

\item{by, num}{Intervals between elements or number of elements; specify only
one.}

\item{label_dodge}{Numeric; the orthogonal distance of the text from the axis
or isoline, as a proportion of the minimum of the plot width and height.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{parse}{If \code{TRUE}, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}

\item{check_overlap}{If \code{TRUE}, text that overlaps previous text in the
same layer will not be plotted. \code{check_overlap} happens at draw time and in
the order of the data. Therefore data should be arranged by the label
column before calling \code{geom_text()}. Note that this argument is not
supported by \code{geom_label()}.}

\item{na.rm}{Passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A ggproto \link[ggplot2:layer]{layer}.
}
\description{
\code{geom_isoline()} renders isolines along row or column axes.
}
\section{Biplot layers}{

\code{\link[=ggbiplot]{ggbiplot()}} uses \code{\link[ggplot2:fortify]{ggplot2::fortify()}} internally to produce a single data
frame with a \code{.matrix} column distinguishing the subjects (\code{"rows"}) and
variables (\code{"cols"}). The stat layers \code{stat_rows()} and \code{stat_cols()} simply
filter the data frame to one of these two.

The geom layers \verb{geom_rows_*()} and \verb{geom_cols_*()} call the corresponding
stat in order to render plot elements for the corresponding factor matrix.
\verb{geom_dims_*()} selects a default matrix based on common practice, e.g.
points for rows and arrows for columns.
}

\section{Aesthetics}{

\code{geom_isoline()} understands the following aesthetics (required aesthetics
are in bold):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \code{colour}
\item \code{alpha}
\item \code{linewidth}
\item \code{linetype}
\item \code{center}, \code{scale}
\item \code{angle}
\item \code{hjust}
\item \code{vjust}
\item \code{family}
\item \code{fontface}
\item \code{text_colour}, \code{text_alpha}, \code{text_size},
\item \code{group}
}

The prefixed aesthetics \verb{text_*} are used by the text elements and will
inherit any values passed to their un-prefixed counterparts.
}

\examples{
# Reaven & Miller overt & chemical diabetes test data and group classification
head(heplots::Diabetes)
# default (standardized) linear discriminant analysis of groups on tests
diabetes_lda <- MASS::lda(group ~ ., heplots::Diabetes)

# bestow 'tbl_ord' class & augment observation, centroid, and variable fields
as_tbl_ord(diabetes_lda) \%>\%
  augment_ord() \%>\%
  print() -> diabetes_lda

# row-standard biplot
diabetes_lda \%>\%
  confer_inertia(1) \%>\%
  ggbiplot(aes(label = name), elements = "active") +
  theme_bw() + theme_biplot() +
  geom_rows_text() +
  geom_cols_vector(subset = c(1, 3, 4)) +
  geom_cols_text_radiate(subset = c(1, 3, 4), size = 3) +
  geom_cols_isoline(subset = c(1, 3, 4), alpha = .25, num = 4L,
                    label_dodge = -.03, text_alpha = .5, text_size = 3) +
  ggtitle(
    "LDA of Reaven & Miller diabetes groups",
    "Row-standard biplot of standardized LDA"
  )
}
\seealso{
Other geom layers: 
\code{\link{geom_axis}()},
\code{\link{geom_lineranges}()},
\code{\link{geom_origin}()},
\code{\link{geom_text_radiate}()},
\code{\link{geom_unit_circle}()},
\code{\link{geom_vector}()}
}
\concept{geom layers}
