% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{ore_switch}
\alias{ore_switch}
\alias{ore.switch}
\title{String multiplexing}
\usage{
ore_switch(text, ..., options = "", encoding = getOption("ore.encoding"))
}
\arguments{
\item{text}{A vector of strings to match against.}

\item{...}{One or more string arguments specifying a possible return value.
These are generally named with a regex, and the string is only used for a
given \code{text} element if the regex matches (and no previous one
matched). These strings may reference captured groups. Unnamed arguments
match unconditionally, and will always be taken literally.}

\item{options}{A string composed of characters indicating variations on the
usual interpretation of the regex. These may currently include \code{"i"}
for case-insensitive matching, and \code{"m"} for multiline matching (in
which case \code{"."} matches the newline character).}

\item{encoding}{A string specifying the encoding that matching will take
place in. The default is given by the \code{"ore.encoding"} option, which
is usually set automatically from the current locale when the package is
loaded, but can be modified if needed.}
}
\value{
A character vector of the same length as \code{text}, containing the
  multiplexed strings. If none of the regexes matched, the corresponding
  element will be \code{NA}.
}
\description{
This function maps one character vector to another, based on sequential
matching to a series of regular expressions. The return value corresponding
to each element in the source text is chosen based on the first matching
regex: once matched, later options are ignored.
}
\examples{
# Extract digits where present; otherwise return zero
ore_switch(c("2 dogs","no dogs"), "\\\\d+"="\\\\0", "0")
}
\seealso{
\code{\link{ore_subst}} for details of back-reference syntax.
}
