% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ormPredictionplot.R
\name{predict_with_ci}
\alias{predict_with_ci}
\title{Create a Prediction data.frame with confidence intervals}
\usage{
predict_with_ci(x, ..., np = 100, fun = stats::plogis,
  conf.int = 0.95, boot.type = "bca")
}
\arguments{
\item{x}{
	an \code{rms} fit object, or for \code{print} the result of \code{Predict}.
	\code{options(datadist="d")} must have been specified (where
	\code{d} was created by \code{datadist}), or 
	it must have been in effect when the the model was fitted.}

\item{...}{
	One or more variables to vary, or single-valued adjustment values.
	Specify a variable name without an equal sign to use the default
	display range, or any range 
	you choose (e.g. \code{seq(0,100,by=2),c(2,3,7,14)}). 
	The default list of values for which predictions are made
	is taken as the list of unique values of the variable if they number fewer
	than 11. For variables with \eqn{>10} unique values, \code{np}
	equally spaced values in the range are used for plotting if the
	range is not specified.  Variables not specified are set to the default
	adjustment value \code{limits[2]}, i.e. the median for continuous
	variables and a reference category for 	non-continuous ones.
	Later variables define adjustment settings.
	For categorical variables, specify the class labels in quotes when
	specifying variable values.  If the levels of a categorical variable
	are numeric, you may omit the quotes.  For variables not described
	using \code{datadist}, you must specify explicit ranges and
	adjustment settings for predictors  that were in the model.
	If no variables are specified in \dots, predictions will be made by
	separately varying all predictors in the model over their default
	range, holding the other predictors at their adjustment values.
	This has the same effect as specifying \code{name} as a vector
	containing all the predictors.  For \code{rbind}, \dots represents a
	series of results from \code{Predict}.  If you name the results,
	these names will be taken as the values of the new \code{.set.}
	variable added to the concatenated data frames.  See an example below.
  }

\item{np}{
	the number of equally-spaced points computed for continuous
	predictors that vary, i.e., when the specified value is \code{.}
	or \code{NA}
  }

\item{fun}{an optional transformation of the linear predictor.
	Specify \code{fun='mean'} if the fit is a proportional odds model
	fit and you ran \code{bootcov} with \code{coef.reps=TRUE}.  This
	will let the mean function be re-estimated for each bootstrap rep to
	properly account for all sources of uncertainty in estimating the
	mean response.}

\item{conf.int}{
	confidence level.  Default is 0.95.  Specify \code{FALSE} to suppress.}

\item{boot.type}{set to \code{'bca'} to compute BCa confidence
	limits or \code{'basic'} to use the basic bootstrap.  The default is
	to compute percentile intervals}
}
\value{
a \code{data.frame}
}
\description{
returns a \code{data.frame} object similar to the \code{\link[rms]{Predict}}
however it adds a column dependent that lists all factor levels with
appropriate confidence intervals calculated for each level. It is similar to
\code{\link[rms]{predict.lrm}} with \code{type="fitted.ind"} but also generates
selected confidence intervals.
}
\examples{
set.seed(123)
#load the libraries
library(rms)
library(ormPlot)

#make the datadist
dd<-rms::datadist(educ_data)
options(datadist="dd")

#create the model
cran_model <- orm(educ_3 ~ Rural + sex + max_SEP_3 + cran_rzs, data = educ_data)

#get the predictions of the orm model with confidence intervals for all levels
predictiondf<-predict_with_ci(cran_model, cran_rzs, Rural, sex, max_SEP_3)
#show the predictions head
head(predictiondf)

#get the predictions of the orm model with confidence intervals for sex only
predictiondf_sex<-predict_with_ci(cran_model,  sex)
#show the predictions head
head(predictiondf_sex)
}
\seealso{
\code{\link[rms]{Predict}},\code{\link[rms]{orm}}, \code{\link[rms]{predict.lrm}}
}
