% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{surv_solver}
\alias{surv_solver}
\title{surv_solver}
\usage{
surv_solver(B, X, Phit, inRisk, Fail_Ind, bw, rho, eta, gamma, tau, epsilon,
  btol, ftol, gtol, maxitr, verbose)
}
\arguments{
\item{B}{A matrix of the parameters \code{B}, the columns are subject to the orthogonality constraint}

\item{X}{The covariate matrix}

\item{Phit}{Phit as defined in Sun et al. (2017)}

\item{inRisk}{A matrix of indicators shows whether each subject is still alive at each time point}

\item{Fail_Ind}{The locations of the failure subjects}

\item{bw}{A Kernel bandwidth, assuming each variable have unit variance}

\item{rho}{(don't change) Parameter for control the linear approximation in line search}

\item{eta}{(don't change) Factor for decreasing the step size in the backtracking line search}

\item{gamma}{(don't change) Parameter for updating C by Zhang and Hager (2004)}

\item{tau}{(don't change) Step size for updating}

\item{epsilon}{(don't change) Parameter for approximating numerical gradient}

\item{btol}{(don't change) The \code{$B$} parameter tolerance level}

\item{ftol}{(don't change) Estimation equation 2-norm tolerance level}

\item{gtol}{(don't change) Gradient tolerance level}

\item{maxitr}{Maximum number of iterations}

\item{verbose}{Should information be displayed}
}
\value{
The optimizer \code{B} for the esitmating equation.
}
\description{
The main optimization function for survival dimensional reduction, the IR-CP method. This is an internal function and should not be called directly.
}
\examples{
# This function should be called internally. When having all objects pre-computed, one can call
# surv_solver(B, X, Phit, inRisk, bw, Fail.Ind,
#             rho, eta, gamma, tau, epsilon, btol, ftol, gtol, maxitr, verbose)
# to solve for the parameters B.

}
\references{
Sun, Q., Zhu, R., Wang T. and Zeng D. "Counting Process Based Dimension Reduction Method for Censored Outcomes." (2017) \url{https://arxiv.org/abs/1704.05046} .

Wen, Z. and Yin, W., "A feasible method for optimization with orthogonality constraints." Mathematical Programming 142.1-2 (2013): 397-434. DOI: \url{https://doi.org/10.1007/s10107-012-0584-1}
}
\keyword{internal}
