% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim-osmdata.R
\name{trim_osmdata}
\alias{trim_osmdata}
\title{trim_osmdata}
\usage{
trim_osmdata(dat, bb_poly, exclude = TRUE)
}
\arguments{
\item{dat}{An \link{osmdata} object returned from \link{osmdata_sf} or
\link{osmdata_sp}.}

\item{bb_poly}{A matrix representing a bounding polygon obtained with
\code{getbb (..., format_out = "polygon")} (and possibly selected from
resultant list where multiple polygons are returned).}

\item{exclude}{If TRUE, objects are trimmed exclusively, only retaining those
strictly within the bounding polygon; otherwise all objects which partly
extend within the bounding polygon are retained.}
}
\value{
A trimmed version of \code{dat}, reduced only to those components
lying within the bounding polygon.
}
\description{
Trim an \link{osmdata} object to within a bounding polygon
}
\note{
It will generally be necessary to pre-load the \pkg{sf} package for
this function to work correctly.
}
\examples{
\dontrun{
dat <- opq ("colchester uk") \%>\%
            add_osm_feature (key="highway") \%>\%
            osmdata_sf (quiet = FALSE)
bb <- getbb ("colchester uk", format_out = "polygon")
library (sf) # required for this function to work
dat_tr <- trim_osmdata (dat, bb)
bb <- getbb ("colchester uk", format_out = "sf_polygon")
class (bb) # sf data.frame
dat_tr <- trim_osmdata (dat, bb)
bb <- as (bb, "Spatial")
class (bb) # SpatialPolygonsDataFrame
dat_tr <- trim_osmdata (dat, bb)
}
}
