/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.ltl;

import fr.ird.osmose.Cell;
import fr.ird.osmose.ltl.AbstractLTLForcing;
import java.io.IOException;
import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;

public class LTLForcingRomsPisces
extends AbstractLTLForcing {
    String[] planktonFileListNetcdf;
    float[][][] depthOfLayer;
    String[] plktonNetcdfNames;
    private String gridFileName;
    private String strCs_r;
    private String strHC;
    private String strLon;
    private String strLat;
    private String strH;
    float[][] latitude;
    float[][] longitude;
    private int nx;
    private int ny;
    private int nz;

    public LTLForcingRomsPisces(int rank) {
        super(rank);
    }

    @Override
    public void readParameters() {
        int i;
        this.plktonNetcdfNames = new String[this.getConfiguration().getNPlankton()];
        for (i = 0; i < this.getConfiguration().getNPlankton(); ++i) {
            this.plktonNetcdfNames[i] = this.getConfiguration().getString("ltl.netcdf.var.plankton.plk" + i);
        }
        this.planktonFileListNetcdf = new String[this.getConfiguration().findKeys("ltl.netcdf.file.t*").size()];
        for (i = 0; i < this.planktonFileListNetcdf.length; ++i) {
            this.planktonFileListNetcdf[i] = this.getConfiguration().getFile("ltl.netcdf.file.t" + i);
        }
        this.gridFileName = this.getConfiguration().getFile("ltl.netcdf.grid.file");
        this.strLon = this.getConfiguration().getString("ltl.netcdf.var.lon");
        this.strLat = this.getConfiguration().getString("ltl.netcdf.var.lat");
        this.strH = this.getConfiguration().getString("ltl.netcdf.var.bathy");
        this.strCs_r = this.getConfiguration().getString("ltl.netcdf.var.csr");
        this.strHC = this.getConfiguration().getString("ltl.netcdf.var.hc");
    }

    @Override
    public void initLTLGrid() {
        try {
            NetcdfFile ncIn = NetcdfFile.open(this.gridFileName, null);
            int[] shape = ncIn.findVariable(this.strLon).getShape();
            this.nx = shape[1];
            this.ny = shape[0];
            this.nz = this.getCs_r(ncIn).length;
            Array arrLon = ncIn.findVariable(this.strLon).read();
            Array arrLat = ncIn.findVariable(this.strLat).read();
            if (arrLon.getElementType() == Float.TYPE) {
                this.longitude = (float[][])arrLon.copyToNDJavaArray();
                this.latitude = (float[][])arrLat.copyToNDJavaArray();
            } else {
                this.longitude = new float[this.ny][this.nx];
                this.latitude = new float[this.ny][this.nx];
                Index index = arrLon.getIndex();
                for (int j = 0; j < this.ny; ++j) {
                    for (int i = 0; i < this.nx; ++i) {
                        index.set(j, i);
                        this.longitude[j][i] = arrLon.getFloat(index);
                        this.latitude[j][i] = arrLat.getFloat(index);
                    }
                }
            }
            this.depthOfLayer = this.getCstSigLevels(ncIn);
            this.findValidMapIndex();
        }
        catch (IOException ex) {
            this.error("Error while reading the LTL grid from file " + this.gridFileName, ex);
        }
    }

    private void findValidMapIndex() {
        this.icoordLTLGrid = new ArrayList[this.getGrid().get_ny()][this.getGrid().get_nx()];
        this.jcoordLTLGrid = new ArrayList[this.getGrid().get_ny()][this.getGrid().get_nx()];
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                if (!(this.latitude[j][i] >= this.getGrid().getLatMin()) || !(this.latitude[j][i] <= this.getGrid().getLatMax()) || !(this.longitude[j][i] >= this.getGrid().getLongMin()) || !(this.longitude[j][i] <= this.getGrid().getLongMax())) continue;
                int jGrid = (int)Math.floor((this.latitude[j][i] - this.getGrid().getLatMin()) / this.getGrid().getdLat());
                int iGrid = (int)Math.floor((this.longitude[j][i] - this.getGrid().getLongMin()) / this.getGrid().getdLong());
                jGrid = Math.min(jGrid, this.getGrid().get_ny() - 1);
                iGrid = Math.min(iGrid, this.getGrid().get_nx() - 1);
                if (this.getGrid().getCell(iGrid, jGrid).isLand()) continue;
                if (null == this.icoordLTLGrid[jGrid][iGrid]) {
                    this.icoordLTLGrid[jGrid][iGrid] = new ArrayList();
                    this.jcoordLTLGrid[jGrid][iGrid] = new ArrayList();
                }
                this.icoordLTLGrid[jGrid][iGrid].add(i);
                this.jcoordLTLGrid[jGrid][iGrid].add(j);
            }
        }
        for (int j = 0; j < this.getGrid().get_ny(); ++j) {
            for (int i = 0; i < this.getGrid().get_nx(); ++i) {
                Cell cell;
                if (this.getGrid().getCell(i, j).isLand() || null != this.icoordLTLGrid[j][i] && !this.icoordLTLGrid[j][i].isEmpty()) continue;
                this.icoordLTLGrid[j][i] = new ArrayList();
                this.jcoordLTLGrid[j][i] = new ArrayList();
                if (j > 0 && !(cell = this.getGrid().getCell(i, j - 1)).isLand()) {
                    this.icoordLTLGrid[j][i].addAll(this.icoordLTLGrid[j - 1][i]);
                    this.jcoordLTLGrid[j][i].addAll(this.jcoordLTLGrid[j - 1][i]);
                }
                if (i > 0 && !(cell = this.getGrid().getCell(i - 1, j)).isLand()) {
                    this.icoordLTLGrid[j][i].addAll(this.icoordLTLGrid[j][i - 1]);
                    this.jcoordLTLGrid[j][i].addAll(this.jcoordLTLGrid[j][i - 1]);
                }
                if (j < this.getGrid().get_ny() - 1 && !(cell = this.getGrid().getCell(i, j + 1)).isLand()) {
                    this.icoordLTLGrid[j][i].addAll(this.icoordLTLGrid[j + 1][i]);
                    this.jcoordLTLGrid[j][i].addAll(this.jcoordLTLGrid[j + 1][i]);
                }
                if (i >= this.getGrid().get_nx() - 1 || (cell = this.getGrid().getCell(i + 1, j)).isLand()) continue;
                this.icoordLTLGrid[j][i].addAll(this.icoordLTLGrid[j][i + 1]);
                this.jcoordLTLGrid[j][i].addAll(this.jcoordLTLGrid[j][i + 1]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    double[][] getRawBiomass(int iPlankton, int iStepSimu) {
        String name = this.planktonFileListNetcdf[this.getIndexStepLTL(iStepSimu)];
        float[][][] data3d = null;
        NetcdfFile nc = null;
        try {
            nc = NetcdfFile.open(name);
            data3d = (float[][][])nc.findVariable(this.plktonNetcdfNames[iPlankton]).read().reduce().copyToNDJavaArray();
        }
        catch (IOException ex) {
            this.error("Error loading plankton variable " + this.plktonNetcdfNames[iPlankton] + " from file " + name, ex);
        }
        finally {
            if (null != nc) {
                try {
                    nc.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.verticalIntegration(data3d, this.depthOfLayer, this.getConfiguration().getFloat("ltl.integration.depth"));
    }

    @Override
    public int getIndexStepLTL(int iStepSimu) {
        return iStepSimu % this.getConfiguration().getNStepYear();
    }

    private float[][][] getCstSigLevels(NetcdfFile ncIn) throws IOException {
        double[][] hRho;
        double[] sc_r = new double[this.nz];
        Array arrH = ncIn.findVariable(this.strH).read();
        if (arrH.getElementType() == Double.TYPE) {
            hRho = (double[][])arrH.copyToNDJavaArray();
        } else {
            hRho = new double[this.ny][this.nx];
            Index index = arrH.getIndex();
            for (int j = 0; j < this.ny; ++j) {
                for (int i = 0; i < this.nx; ++i) {
                    hRho[j][i] = arrH.getDouble(index.set(j, i));
                }
            }
        }
        double hc = this.getHc(ncIn);
        double[] Cs_r = this.getCs_r(ncIn);
        int k = this.nz;
        while (k-- > 0) {
            sc_r[k] = ((double)(k - this.nz) + 0.5) / (double)this.nz;
        }
        float[][][] z_r = new float[this.nz][this.ny][this.nx];
        switch (this.getVertCoordType(ncIn)) {
            case OLD: {
                int j;
                int i = this.nx;
                while (i-- > 0) {
                    j = this.ny;
                    while (j-- > 0) {
                        int k2 = this.nz;
                        while (k2-- > 0) {
                            z_r[k2][j][i] = (float)(hc * (sc_r[k2] - Cs_r[k2]) + Cs_r[k2] * hRho[j][i]);
                        }
                    }
                }
                break;
            }
            case NEW: {
                int j;
                int i = this.nx;
                while (i-- > 0) {
                    j = this.ny;
                    while (j-- > 0) {
                        int k3 = this.nz;
                        while (k3-- > 0) {
                            z_r[k3][j][i] = (float)(hRho[j][i] * (sc_r[k3] * hc + Cs_r[k3] * hRho[j][i]) / (hc + hRho[j][i]));
                        }
                    }
                }
                break;
            }
        }
        return z_r;
    }

    private double getHc(NetcdfFile ncIn) throws IOException {
        if (null != ncIn.findGlobalAttribute(this.strHC)) {
            return ncIn.findGlobalAttribute(this.strHC).getNumericValue().floatValue();
        }
        if (null != ncIn.findVariable(this.strHC)) {
            return ncIn.findVariable(this.strHC).readScalarFloat();
        }
        throw new IOException("S-coordinate critical depth (hc) could not be found, neither among variables nor global attributes");
    }

    private double[] getCs_r(NetcdfFile ncIn) throws IOException {
        if (null != ncIn.findGlobalAttribute(this.strCs_r)) {
            Attribute attrib_cs_r = ncIn.findGlobalAttribute(this.strCs_r);
            double[] Cs_r = new double[attrib_cs_r.getLength()];
            for (int k = 0; k < Cs_r.length - 1; ++k) {
                Cs_r[k] = attrib_cs_r.getNumericValue(k).floatValue();
            }
            return Cs_r;
        }
        if (null != ncIn.findVariable(this.strCs_r)) {
            Array arr_cs_r = ncIn.findVariable(this.strCs_r).read();
            double[] Cs_r = new double[arr_cs_r.getShape()[0]];
            for (int k = 0; k < Cs_r.length - 1; ++k) {
                Cs_r[k] = arr_cs_r.getFloat(k);
            }
            return Cs_r;
        }
        throw new IOException("S-coordinate stretching curves at Rho-points (Cs_r) could not be found, neither among variables nor global attributes");
    }

    private VertCoordType getVertCoordType(NetcdfFile ncIn) {
        String strCoordType;
        if (null != ncIn.findGlobalAttribute("VertCoordType") && (strCoordType = ncIn.findGlobalAttribute("VertCoordType").getStringValue()).toLowerCase().equals(VertCoordType.OLD.name().toLowerCase())) {
            return VertCoordType.NEW;
        }
        if (null != ncIn.findVariable("Vtransform")) {
            try {
                int vTransform = ncIn.findVariable("Vtransform").readScalarInt();
                switch (vTransform) {
                    case 1: {
                        return VertCoordType.OLD;
                    }
                    case 2: {
                        return VertCoordType.NEW;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return VertCoordType.OLD;
    }

    private static enum VertCoordType {
        NEW,
        OLD;

    }
}

