/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.util.filter;

import fr.ird.osmose.Osmose;
import fr.ird.osmose.util.filter.FilteredSet;
import fr.ird.osmose.util.filter.IFilter;
import java.util.Arrays;
import java.util.HashSet;

public class FilteredSets {
    public static <T> FilteredSet<T> subset(FilteredSet<T> set, IFilter<? super T>[] filters) {
        FilteredSet<? super T> subset = new FilteredSet<T>(set, filters);
        FilteredSets.refresh(subset);
        return subset;
    }

    public static <T> FilteredSet<T> subset(FilteredSet<T> set, IFilter<? super T> filter) {
        return FilteredSets.subset(set, new IFilter[]{filter});
    }

    public static <T> void refresh(FilteredSet<T> set) {
        if (null != set.getParent()) {
            set.clear();
            IFilter<T>[] filters = set.getFilters();
            for (Object member : set.getParent()) {
                boolean accept = true;
                if (filters == null) continue;
                for (IFilter iFilter : filters) {
                    boolean bl = accept = accept && iFilter.accept(member);
                    if (!accept) break;
                }
                if (!accept) continue;
                set.add(member);
            }
        }
    }

    public static <T> FilteredSet<T> intersect(FilteredSet<T> subset1, FilteredSet<T> subset2) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(subset1);
        set.addAll(subset2);
        FilteredSet<T> merged = new FilteredSet<T>();
        merged.addAll(set);
        HashSet<IFilter<T>> filters = new HashSet<IFilter<T>>();
        filters.addAll(Arrays.asList(subset1.getFilters()));
        filters.addAll(Arrays.asList(subset2.getFilters()));
        return FilteredSets.subset(merged, filters.toArray(new IFilter[filters.size()]));
    }

    public static Osmose getOsmose() {
        return Osmose.getInstance();
    }
}

