% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{setknot}
\alias{setknot}
\title{Set knot points}
\arguments{
\item{om}{an \code{\link{outermod}} instance}

\item{knotslist}{a list of one dimensional vectors}
}
\value{
no value is returned, \code{om} is updated
}
\description{
\preformatted{
setknot(om, knotslist)
}
Sets the knot points of \code{om} to \code{knotslist} to estimate the 
eigenfunctions and eigenvalues. It will naturally check if the knot points 
have the same dimension as the covariance functions.  It will also check if 
the knot points are within reasonable bounds for the covariance functions.
}
\examples{
om = new(outermod)
setcovfs(om, c("mat25", "mat25", "mat25"))
knotslist = list(seq(0,1,by=0.01),seq(0,1,by=0.01),seq(0,1,by=0.01))
setknot(om, knotslist)
}
\seealso{
\code{\link{outermod}}, \code{\link{setcovfs}}
}
