% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateOutliers.r
\name{evaluateOutliers}
\alias{evaluateOutliers}
\title{Evaluate Outliers}
\usage{
evaluateOutliers(original_data, anomaly_data, anomaly_result)
}
\arguments{
\item{original_data}{A data frame containing the original data.}

\item{anomaly_data}{A data frame containing the anomaly data.}

\item{anomaly_result}{A data frame containing the predicted anomalies.}
}
\value{
A data frame containing the evaluation metrics.
}
\description{
This function evaluates the performance of the outlier detection algorithm.
}
\examples{
anomaly_data <- generateOutliers(iris, p = 0.05, sd_factor = 5, seed = 123)
qrf<- outqrf(anomaly_data)
evaluateOutliers(iris,anomaly_data,qrf$outliers)
}
