% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_overture.R
\name{record_overture}
\alias{record_overture}
\alias{snapshot_overture}
\title{Download Overture Maps Data to Local Directory}
\usage{
record_overture(curtain_call, output_dir, overwrite = FALSE, write_opts = NULL)

snapshot_overture(
  curtain_call,
  output_dir = tempdir(),
  overwrite = TRUE,
  write_opts = NULL
)
}
\arguments{
\item{curtain_call}{A overture_call object.}

\item{output_dir}{The directory where the data will be saved.}

\item{overwrite}{Logical, if FALSE (default), existing directories will not be
overwritten.}

\item{write_opts}{a character vector passed to DuckDB's COPY command.}
}
\value{
Another tbl_lazy. Use \code{\link[dplyr:explain]{dplyr::show_query()}} to see the generated query, and
use \code{\link[dplyr:compute]{dplyr::collect()}} to execute the query and return data to R.

An 'overture_call' for the downloaded data
}
\description{
This function downloads Overture Maps data to a local directory, maintaining
the same partition structure as in S3. \code{snapshot_overture} defaults
'output_dir' to \code{tempdir()} and overwrite to TRUE.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
broadway <- c(xmin = -73.99, ymin = 40.76, xmax = -73.98, ymax = 40.76)
buildings <- open_curtain("building", spatial_filter = bbox)
local_buildings <- record_overture(buildings, tempdir(), overwrite = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://duckdb.org/docs/data/partitioning/partitioned_writes}{DuckDB documentation on partitioned writes}
}
