################################################################################
#
#'
#' Data sources for OxCOVID19 Database
#'
#' @format A named list of 6 tibbles of data sources for **OxCOVID19 Database**
#'
#' | **Table name** | **Description** |
#' | :--- | :--- |
#' | **epidemiology** | Tibble of sources for epidemiology table |
#' | **government_response** | Tibble of sources for government response table |
#' | **country_statistics** | Tibble of sources for country statistics table |
#' | **mobility** | Tibble of sources for mobility table |
#' | **weather** | Tibble of sources for weather table |
#' | **administrative_division** | Tibble of sources for administrative division table |
#'
#' @examples
#' data_sources
#'
#' @source \url{https://covid19.eng.ox.ac.uk/data_sources.html}
#'
#
################################################################################
"data_sources"


################################################################################
#
#'
#' Data structures for OxCOVID19 Database
#'
#' @format A named list of 6 tibbles of data structures for **OxCOVID19 Database**
#'
#' | **Table name** | **Description** |
#' | :--- | :--- |
#' | **epidemiology** | Tibble of description of fields for epidemiology table |
#' | **government_response** | Tibble of description of fields for government response table |
#' | **country_statistics** | Tibble of description for fields for country statistics table |
#' | **mobility** | Tibble of description for fields for mobility table |
#' | **weather** | Tibble of description for fields for weather table |
#' | **administrative_division** | Tibble of description for fields for administrative division table |
#'
#' @examples
#' data_structures
#'
#' @source \url{https://covid19.eng.ox.ac.uk/data_schema.html}
#'
#
################################################################################
"data_structures"

