% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop_data.R
\name{crop_data}
\alias{crop_data}
\title{Crop precipitation data sets}
\usage{
crop_data(nc_path, shp_path, save_nc = FALSE)
}
\arguments{
\item{nc_path}{a character string with the path to the ".nc" file or a raster object}

\item{shp_path}{a character string with the path to the ".shp" file.}

\item{save_nc}{logical. If TRUE will write a ".nc" file with the cropped data and there will be no return value.}
}
\value{
a raster brick with cropped data
}
\description{
The function \code{crop_data} crops the data sets using a shapefile mask.
}
\examples{
\dontrun{
x <- crop_data("gpm_imerg.nc", "cze.shp")
crop_data("gpm_imerg.nc", "cze.shp", TRUE)
w <- raster::brick("dummie.nc")
z <- crop_data(w, "cze.shp")
}
}
