% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_ts.R
\name{make_ts}
\alias{make_ts}
\title{Generate time series}
\usage{
make_ts(data, name = NULL, autosave = FALSE)
}
\arguments{
\item{data}{a character string with the path to the data file. Or a RasterBrick}

\item{name}{a character string with short data name. Suitable options are:
\itemize{
\item{"20cr" for 20CR v3,}
\item{"chirps" for CHIRPS v2.0,}
\item{"cmap" for CMAP standard version,}
\item{"cmorph" for CMORPH,}
\item{"cpc" for CPC-Global,}
\item{"cru-ts" for CRU_TS v4.06,}
\item{"em-earth" for EM-EARTH,}
\item{"era20c" for ERA-20C,}
\item{"era5" for ERA5,}
\item{"fldas" for FLDAS,}
\item{"ghcn" for GHCN-M v2,}
\item{"gldas-clsm" for GLDAS CLSM,}
\item{"gldas-noah" for GLDAS NOAH,}
\item{"gldas-vic" for GLDAS VIC,}
\item{"gleam" for GLEAM v3.7a,}
\item{"gpcc" for GPCC v2020,}
\item{"gpcp" for GPCP v2.3,}
\item{"gpm_imerg" for GPM IMERGM Final v06,}
\item{"jra55" for JRA-55,}
\item{"merra2" for MERRA-2,}
\item{"mswep" for MSWEP v2.8,}
\item{"ncep-doe" for NCEP/DOE,}
\item{"ncep-ncar" for NCEP/NCAR,}
\item{"persiann" for PERSIANN-CDR,}
\item{"precl" for PREC/L,}
\item{"terraclimate" for TerraClimate,}
\item{"trmm-3b43" for TRMM 3B43 v7,}
\item{"udel" for UDEL v501.}
}}

\item{autosave}{logical FALSE (default). If TRUE data will be automatically stored in the same location of the input file}
}
\value{
A data.table
}
\description{
The function \code{make_ts} generates a csv time series and stored in the same location of the input file.
}
\examples{
\dontrun{
make_ts("gpcp_tp_mm_global_197901_202205_025_monthly.nc")
make_ts("dummie.nc")
}
}
