% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rates.R
\name{lynchD}
\alias{lynchD}
\title{Compute Lynch's Delta rate metric}
\usage{
lynchD(y, gen.per.t = 1e+06, pool = TRUE, method = c("Joint", "AD"),
  ...)
}
\arguments{
\item{y}{a \code{paleoTS} object}

\item{gen.per.t}{the number of generations per unit time}

\item{pool}{logical, whether variances should be pooled over samples}

\item{method}{parameterization to use: based on ancestor-descendant (AD)
differences, or Joint consideration of all samples}

\item{...}{further arguments, passed to \code{opt.URW} or \code{opt.joint.URW}}
}
\value{
\item{D}{  value of rate metric }
\item{pooled.var}{ value
  of pooled within-sample variance }
  \item{gen.per.t}{ number of generations per unit time }
  \item{vstep}{ computed \code{Vstep}, at the original time
  scale of \code{y}}
  \item{drift.range}{ expected minimum and maximum values
  of \code{D} consistent with neutral evolution }
  \item{result}{ conclusion reached about the plausibility of neutral evolution }
}
\description{
This function computes D, the rate metric proposed by Lynch
  (1990).  This metric derives from the random walk model, with \code{D =
  Vstep/(2Vp)}, where \code{Vstep} is the step variance of the unbiased
  random walk, and \code{Vp} is the within sample variance, pooled among
  samples.  Under mutation - drift equilibrium, \code{D} is expected to range
  approximately between 5e-5 and 5e-3.
}
\examples{
y <- sim.GRW(ns = 20, ms = 0, vs = 1e-4, tt=seq(0, 1e6, length.out=20))  # per-year simulation
lynchD(y, gen.per.t = 1)
}
\references{
Lynch (1990). The rate of morphological evolution in mammals from the
 standpoint of the neutral expectation. \emph{The American Naturalist}
 136:727-741.
  Hunt, G. 2012. Fitting and comparing models of phyletic evolution: random
  walks and beyond.  \emph{Paleobiology} 38:351-373.
}
