% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/footeValues.R
\name{footeValues}
\alias{footeValues}
\title{Calculates Values for Foote's Inverse Survivorship Analyses}
\usage{
footeValues(p, q, r, PA_n = 0, PB_1 = 0, p_cont = TRUE, q_cont = TRUE, Nb = 1)
}
\arguments{
\item{p}{Instantaneous origination/branching rate of taxa. Under 
a continuous model, assumed to be \emph{per interval}, or equal
to the product of interval lengths and the rates per lineage time
units for each interval. 
Under a pulsed mode (\code{p_cont = FALSE}), \code{p} is a 
per-interval 'rate' which can exceed 1 (because diversity can
more than double; Foote, 2003a). Given as a vector with length
equal to the number of intervals, so a different value may be
given for each separate interval. Must be the same length as
\code{q} and \code{r}.}

\item{q}{Instantaneous extinction rate of taxa. Under 
a continuous model, assumed to be \emph{per interval}, or
equal to the product of interval lengths and the rates per lineage
time units for each interval.
Under a pulsed mode (\code{q_cont = FALSE}), \code{q} is a  
per-interval 'rate' but which cannot be observed to exceed 1
(because you can't have more taxa go extinct than exist). Given as
a vector with length equal to the number of intervals, so a 
different value may be given for each separate interval. 
Must be the same length as \code{p} and \code{r}.}

\item{r}{Instantaneous sampling rate of taxa, assumed to be
\emph{per interval}, or equal to the product of interval lengths
and the rates per lineage time units for each interval. Given as
a vector with length equal to the number of intervals, so a 
different value may be given for each separate interval. 
Must be the same length as \code{p} and \code{q}.}

\item{PA_n}{The probability of sampling a taxon after the last interval 
included in a survivorship study. Usually zero for extinct groups, 
although more logically has the value of 1 when there are still extant
taxa (i.e., if the last interval is the Holocene and the group is
still alive, the probability of sampling them later is probably 1...).
Should be a value between 0 and 1.}

\item{PB_1}{The probability of sampling a taxon before the first interval 
included in a survivorship study.
Should be a value between 0 and 1.}

\item{p_cont}{If \code{TRUE} (the default), then origination is assumed to be a 
continuous time process with an instantaneous rate. If \code{FALSE}, the origination
is treated as a pulsed discrete-time process with a probability.}

\item{q_cont}{If \code{TRUE} (the default), then extinction is assumed to be a 
continuous time process with an instantaneous rate. If \code{FALSE}, the extinction
is treated as a pulsed discrete-time process with a probability.}

\item{Nb}{The number of taxa that enter an interval (the \code{b} is for 'bottom'). This
is an arbitrary constant used to scale other values in these calculations and
can be safely set to 1.}
}
\value{
Returns a matrix with number of rows equal to the number of intervals 
(i.e. the length of \code{p}, \code{q} and \code{r})
and named columns representing the different values calculated by the function:
\code{"Nb"}, \code{"Nbt"}, \code{"NbL"}, \code{"NFt"}, \code{"NFL"}, \code{"PD_bt"}, 
\code{"PD_bL"}, \code{"PD_Ft"}, \code{"PD_FL"}, \code{"PA"}, \code{"PB"},
\code{"Xbt"}, \code{"XbL"}, \code{"XFt"} and \code{"XFL"}.
}
\description{
This function calculates the intermediary values needed for
fitting Foote's inverse survivorship analyses, as listed in the
table of equations in Foote (2003), with the analyses themselves
described further in Foote (2001) and Foote (2005).
}
\details{
Although most calculations in this function agree
with the errata for Foote's 2003 table (see references), there were some additional
corrections for the probability of \code{D} given \code{FL} (\code{Prob(D|FL)})
made as part of a personal communication in 2013
between the package author and Michael Foote.
}
\examples{
#very simple example with three intervals, same value for all parameters

# example rates (for the most part)
rate <- rep(0.1, 3)
                  
#all continuous
footeValues(rate,rate,rate)	

# origination pulsed
footeValues(rate,rate,rate,p_cont = FALSE)		 

# extinction pulsed
footeValues(rate,rate,rate,q_cont = FALSE) 	 

# all pulsed
footeValues(rate,rate,rate,p_cont = FALSE,q_cont = FALSE) 
}
\references{
Foote, M. 2001. Inferring temporal patterns of preservation, origination, and 
extinction from taxonomic survivorship analysis. \emph{Paleobiology} 27(4):602-630.

Foote, M. 2003a. Origination and Extinction through the Phanerozoic: A New
Approach. \emph{The Journal of Geology} 111(2):125-148.

Foote, M. 2003b. Erratum: Origination and Extinction through the Phanerozoic:
a New Approach. \emph{The Journal of Geology} 111(6):752-753.

Foote, M. 2005. Pulsed origination and extinction in the marine realm.
\emph{Paleobiology} 31(1):6-20.
}
\author{
David W. Bapst, with advice from Michael Foote.
}
