% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc-template.R
\name{pandoc_export_highlight_theme}
\alias{pandoc_export_highlight_theme}
\title{Export highlighting style as JSON file}
\usage{
pandoc_export_highlight_theme(
  style = "pygments",
  output = style,
  version = "default"
)
}
\arguments{
\item{style}{One of the support highlighting style. (See \code{\link[=pandoc_list_highlight_style]{pandoc_list_highlight_style()}}).}

\item{output}{Path (without extension) where to export the JSON \code{.theme}
file. By default, the file will be located in working directory and named
based on the parameter \code{style} (i.e \verb{<style>.theme}).}

\item{version}{Version to use. Default will be the \code{"default"} version. Other possible value are
\itemize{
\item A version number e.g \code{"2.14.1"}
\item The nightly version called \code{"nightly"}
\item The latest installed version with \code{"latest"}
\item Pandoc binary shipped with RStudio IDE with \code{"rstudio"}
\item Pandoc binary found in PATH with \code{"system"}
}}
}
\value{
the filename where the theme has been exported.
}
\description{
Pandoc highlighting can be customize using a JSON \code{.theme} file, passed to
\href{https://pandoc.org/MANUAL.html#option--highlight-style}{\verb{--highlight-style=} flag}. This function
allows to generate the JSON version of one of the supported highlighting
style.
}
\details{
The \code{.theme} extension is required and it will be enforced in during the
export by this function.
}
\note{
This correspond to the \href{https://pandoc.org/MANUAL.html#option--print-highlight-style}{\code{--print-highlight-style} CLI flag} using
also \code{--output} to write a export a data file built in Pandoc.
}
\examples{
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{withr::local_dir(withr::local_tempdir())}
# export tango theme used by Pandoc highlighting to `tango.theme` file
pandoc_export_highlight_theme("tango")
pandoc_export_highlight_theme("pygments", output = "my_theme.theme")
pandoc_export_highlight_theme("zenburn", version = "system")
\dontshow{\}) # examplesIf}
}
