% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_catalog_search.R
\name{ps1_search}
\alias{ps1_search}
\title{Do a general search of the PS1 catalog (possibly without ra/dec/radius)}
\usage{
ps1_search(
  table = c("mean", "stack", "detection", "forced_mean"),
  release = c("dr2", "dr1"),
  columns = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{table}{"mean", "stack", "detection" or "forced_mean"}

\item{release}{"dr1" or "dr2"(default)}

\item{columns}{list of column names to include (NULL means use defaults)}

\item{verbose}{print info about request}

\item{...}{other parameters (e.g., nDetections.min = 2).}
}
\value{
data.frame
}
\description{
Do a general search of the PS1 catalog (possibly without ra/dec/radius)
}
\examples{
\dontrun{
ps1_search(
table='detection',
release='dr2',
objid = '190361393344112894')

ps1_search(
table='mean',
release='dr2',
objid = '190361393344112894',
columns = c('objName', 'raMean', 'decMean', 'rMeanPSFMag'))
}
}
