% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freeCores.R
\name{freeCores}
\alias{freeCores}
\title{Get the Average Number of Free CPU Cores}
\usage{
freeCores(
  memory = c("5min", "15min", "1min"),
  fraction = 0.9,
  default = parallelly::availableCores()
)
}
\arguments{
\item{memory}{(character) The time period used to infer the system load.}

\item{fraction}{(non-negative numeric) A scale factor.}

\item{default}{(integer) The value to be returned if the system load is
unknown, i.e. \code{\link[=cpuLoad]{cpuLoad()}} return missing values.}
}
\value{
An positive integer with attributes \code{loadavg} (named numeric),
\code{maxCores} (named integer), argument \code{memory} (character), and
argument \code{fraction} (numeric).
}
\description{
Get the Average Number of Free CPU Cores
}
\examples{
free <- freeCores()
print(free)

\dontrun{
## Make availableCores() agile to the system load
options(parallelly.availableCores.custom = function() freeCores())
}
}
\keyword{internal}
