% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GetJManyRows}
\alias{GetJManyRows}
\title{GetJManyRows}
\usage{
GetJManyRows(fname, extrows)
}
\arguments{
\item{fname}{String with the file name that contains the binary data.}

\item{extrows}{A numeric vector with the indexes of the rows to be extracted, in R-numbering (from 1)}
}
\value{
A numeric matrix with the values of elements in the requested rows
}
\description{
Returns (as a R numeric matrix) the rows with the requested row numbers from the matrix contained in a jmatrix binary file
}
\examples{
Rf <- matrix(runif(48),nrow=6)
rownames(Rf) <- c("A","B","C","D","E","F")
colnames(Rf) <- c("a","b","c","d","e","f","g","h")
tmpfile1=paste0(tempdir(),"/Rfullfloat.bin")
JWriteBin(Rf,tmpfile1,dtype="float",dmtype="full",comment="Full matrix of floats")
Rf[c(1,4),]
vc<-GetJManyRows(tmpfile1,c(1,4))
vc
}
