% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_aov.R
\name{model_parameters.aov}
\alias{model_parameters.aov}
\title{Parameters from ANOVAs}
\usage{
\method{model_parameters}{aov}(
  model,
  omega_squared = NULL,
  eta_squared = NULL,
  epsilon_squared = NULL,
  df_error = NULL,
  type = NULL,
  ci = NULL,
  alternative = NULL,
  test = NULL,
  power = FALSE,
  keep = NULL,
  drop = NULL,
  parameters = keep,
  table_wide = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{Object of class \code{\link[=aov]{aov()}}, \code{\link[=anova]{anova()}},
\code{aovlist}, \code{Gam}, \code{\link[=manova]{manova()}}, \code{Anova.mlm},
\code{afex_aov} or \code{maov}.}

\item{omega_squared}{Compute omega squared as index of effect size. Can be
\code{"partial"} (the default, adjusted for effect size) or \code{"raw"}.}

\item{eta_squared}{Compute eta squared as index of effect size. Can be
\code{"partial"} (the default, adjusted for effect size), \code{"raw"}  or
\code{"adjusted"} (the latter option only for ANOVA-tables from mixed
models).}

\item{epsilon_squared}{Compute epsilon squared as index of effect size. Can
be \code{"partial"} (the default, adjusted for effect size) or
\code{"raw"}.}

\item{df_error}{Denominator degrees of freedom (or degrees of freedom of the
error estimate, i.e., the residuals). This is used to compute effect sizes
for ANOVA-tables from mixed models. See 'Examples'. (Ignored for
\code{afex_aov}.)}

\item{type}{Numeric, type of sums of squares. May be 1, 2 or 3. If 2 or 3,
ANOVA-tables using \code{car::Anova()} will be returned. (Ignored for
\code{afex_aov}.)}

\item{ci}{Confidence Interval (CI) level for effect sizes
\code{omega_squared}, \code{eta_squared} etc. The default, \code{NULL},
will compute no confidence intervals. \code{ci} should be a scalar between
0 and 1.}

\item{alternative}{A character string specifying the alternative hypothesis;
Controls the type of CI returned: \code{"two.sided"} (default, two-sided CI),
\code{"greater"} or \code{"less"} (one-sided CI). Partial matching is allowed
(e.g., \code{"g"}, \code{"l"}, \code{"two"}...). See section \emph{One-Sided CIs} in
the \href{https://easystats.github.io/effectsize/}{effectsize_CIs vignette}.}

\item{test}{String, indicating the type of test for \code{Anova.mlm} to be
returned. If \code{"multivariate"} (or \code{NULL}), returns the summary of
the multivariate test (that is also given by the \code{print}-method). If
\code{test = "univariate"}, returns the summary of the univariate test.}

\item{power}{Logical, if \code{TRUE}, adds a column with power for each
parameter.}

\item{keep}{Character containing a regular expression pattern that
describes the parameters that should be included (for \code{keep}) or excluded
(for \code{drop}) in the returned data frame. \code{keep} may also be a
named list of regular expressions. All non-matching parameters will be
removed from the output. If \code{keep} is a character vector, every parameter
name in the \emph{"Parameter"} column that matches the regular expression in
\code{parameters} will be selected from the returned data frame (and vice versa,
all parameter names matching \code{drop} will be excluded). Furthermore, if
\code{keep} has more than one element, these will be merged with an \code{OR}
operator into a regular expression pattern like this: \code{"(one|two|three)"}.
If \code{keep} is a named list of regular expression patterns, the names of the
list-element should equal the column name where selection should be
applied. This is useful for model objects where \code{model_parameters()}
returns multiple columns with parameter components, like in
\code{\link[=model_parameters.lavaan]{model_parameters.lavaan()}}. Note that the regular expression pattern
should match the parameter names as they are stored in the returned data
frame, which can be different from how they are printed. Inspect the
\verb{$Parameter} column of the parameters table to get the exact parameter
names.}

\item{drop}{Character containing a regular expression pattern that
describes the parameters that should be included (for \code{keep}) or excluded
(for \code{drop}) in the returned data frame. \code{keep} may also be a
named list of regular expressions. All non-matching parameters will be
removed from the output. If \code{keep} is a character vector, every parameter
name in the \emph{"Parameter"} column that matches the regular expression in
\code{parameters} will be selected from the returned data frame (and vice versa,
all parameter names matching \code{drop} will be excluded). Furthermore, if
\code{keep} has more than one element, these will be merged with an \code{OR}
operator into a regular expression pattern like this: \code{"(one|two|three)"}.
If \code{keep} is a named list of regular expression patterns, the names of the
list-element should equal the column name where selection should be
applied. This is useful for model objects where \code{model_parameters()}
returns multiple columns with parameter components, like in
\code{\link[=model_parameters.lavaan]{model_parameters.lavaan()}}. Note that the regular expression pattern
should match the parameter names as they are stored in the returned data
frame, which can be different from how they are printed. Inspect the
\verb{$Parameter} column of the parameters table to get the exact parameter
names.}

\item{parameters}{Deprecated, alias for \code{keep}.}

\item{table_wide}{Logical that decides whether the ANOVA table should be in
wide format, i.e. should the numerator and denominator degrees of freedom
be in the same row. Default: \code{FALSE}.}

\item{verbose}{Toggle warnings and messages.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Parameters from ANOVAs
}
\note{
For ANOVA-tables from mixed models (i.e. \code{anova(lmer())}), only
partial or adjusted effect sizes can be computed. Note that type 3 ANOVAs
with interactions involved only give sensible and informative results when
covariates are mean-centred and factors are coded with orthogonal contrasts
(such as those produced by \code{contr.sum}, \code{contr.poly}, or
\code{contr.helmert}, but \emph{not} by the default \code{contr.treatment}).
}
\examples{
if (requireNamespace("effectsize", quietly = TRUE)) {
  df <- iris
  df$Sepal.Big <- ifelse(df$Sepal.Width >= 3, "Yes", "No")

  model <- aov(Sepal.Length ~ Sepal.Big, data = df)
  model_parameters(
    model,
    omega_squared = "partial",
    eta_squared = "partial",
    epsilon_squared = "partial"
  )

  model_parameters(
    model,
    omega_squared = "partial",
    eta_squared = "partial",
    ci = .9
  )

  model <- anova(lm(Sepal.Length ~ Sepal.Big, data = df))
  model_parameters(model)
  model_parameters(
    model,
    omega_squared = "partial",
    eta_squared = "partial",
    epsilon_squared = "partial"
  )

  model <- aov(Sepal.Length ~ Sepal.Big + Error(Species), data = df)
  model_parameters(model)

  \dontrun{
    if (require("lme4")) {
      mm <- lmer(Sepal.Length ~ Sepal.Big + Petal.Width + (1 | Species),
        data = df
      )
      model <- anova(mm)

      # simple parameters table
      model_parameters(model)

      # parameters table including effect sizes
      model_parameters(
        model,
        eta_squared = "partial",
        ci = .9,
        df_error = dof_satterthwaite(mm)[2:3]
      )
    }
  }
}
}
