% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters_reduction.R
\name{DRR}
\alias{DRR}
\title{Dimensionality Reduction via Regression (DRR)}
\usage{
DRR(x, n = "all", ...)
}
\arguments{
\item{x}{A dataframe or a statistical model.}

\item{n}{Number of components to extract. If \code{n = "all"} =, then \code{n} is set as the number of variables minus 1 (\code{ncol(x)-1}). If \code{n = "auto"} (default) or \code{n = NULL}, the number of components is selected through \code{\link{n_factors}}. In \code{\link{parameters_reduction}}, can also be \code{"max"}, in which case it will select all the components that are maximally pseudo-loaded (i.e., correlated) by at least one variable.}

\item{...}{Arguments passed to or from other methods.}
}
\description{
Dimensionality Reduction via Regression (DRR) is a very recent technique extending PCA (Laparra et al., 2015). Starting from a rotated PCA, it predicts redundant information from the remaining components using non-linear regression. Some of the most notable advantages of performing PCR are avoidance of multicollinearity between predictors and overfitting mitigation. PCR tends to perform well when the first principal components are enough to explain most of the variation in the predictors. Requires the \pkg{DRR} package to be installed.
}
\examples{
\donttest{
DRR(iris[, 1:4])
}

}
\references{
\itemize{
 \item Laparra, V., Malo, J., & Camps-Valls, G. (2015). Dimensionality reduction via regression in hyperspectral imagery. IEEE Journal of Selected Topics in Signal Processing, 9(6), 1026-1036.
}
}
