% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dof_kenward.R, R/p_value_kenward.R,
%   R/se_kenward.R
\name{dof_kenward}
\alias{dof_kenward}
\alias{p_value_kenward}
\alias{se_kenward}
\title{p-values using Kenward-Roger approximation}
\usage{
dof_kenward(model)

p_value_kenward(model, dof = NULL)

se_kenward(model)
}
\arguments{
\item{model}{A statistical model.}

\item{dof}{Degrees of Freedom.}
}
\value{
The p-values.
}
\description{
An approximate F-test based on the Kenward-Roger (1997) approach.
}
\details{
Inferential statistics (like p-values, confidence intervals and
standard errors) may be biased in mixed models when the number of clusters
is small (even if the sample size of level-1 units is high). In such cases
it is recommended to approximate a more accurate number of degrees of freedom
for such inferential statistics. Unlike simpler approximation heuristics
like the "m-l-1" rule (\code{dof_ml1}), the Kenward-Roger approximation is
also applicable in more complex multilevel designs, e.g. with cross-classified
clusters. However, the "m-l-1" heuristic also applies to generalized
mixed models, while approaches like Kenward-Roger or Satterthwaite are limited
to linear mixed models only.
}
\examples{
\donttest{
library(lme4)
model <- lmer(Petal.Length ~ Sepal.Length + (1 | Species), data = iris)
p_value_kenward(model)
}

}
\references{
Kenward, M. G., & Roger, J. H. (1997). Small sample inference for fixed effects from restricted maximum likelihood. Biometrics, 983-997.
}
\seealso{
\code{dof_kenward()} and \code{se_kenward()} are small helper-functions
to calculate approximated degrees of freedom and standard errors for model
parameters, based on the Kenward-Roger (1997) approach.
\cr \cr
\code{\link{dof_satterthwaite}} and \code{\link{dof_ml1}} approximate degrees
of freedom bases on Satterthwaite's method or the "m-l-1" rule.
}
