% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/opts.R
\name{get_opts}
\alias{get_opts}
\alias{params}
\alias{print.opts}
\alias{set_opts}
\title{Setting/loading and extracting various options into the environment}
\usage{
get_opts(x, envir = opts)

set_opts(..., .dots, envir = opts)

\method{print}{opts}(x, ...)

params(x, envir = opts)
}
\arguments{
\item{x}{a character vector of names of options to extract.}

\item{envir}{environ used to store objects}

\item{...}{set_opts(): a named set of variable/value pairs seperated by comma}

\item{.dots}{set_opts(): A named list, as a alternative to ...}
}
\description{
\itemize{
\item set_opts(): set options into a custom envir
\item get_opts()/params(): extract options
\item print.opts(): print pkg options as a pretty table
}
}
\details{
To use params in your package, follow this these steps: \url{https://github.com/sahilseth/params}
}
\examples{
## set _opts
opts = set_opts(flow_run_path = "~/mypath")
#OR
opts = set_opts(.dots = list(flow_run_path = "~/mypath"))
print(opts)
## get_opts()
get_opts()
get_opts("flow_run_path")
}
\seealso{
\link{read_sheet} \link{load_conf}
}

