% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_additive_mod_mgcv.R
\name{details_gen_additive_mod_mgcv}
\alias{details_gen_additive_mod_mgcv}
\title{Generalized additive models via mgcv}
\description{
\code{\link[mgcv:gam]{mgcv::gam()}} fits a generalized linear model with additive smoother terms
for continuous predictors.
}
\details{
For this engine, there are multiple modes: regression and classification
\subsection{Tuning Parameters}{

This model has 2 tuning parameters:
\itemize{
\item \code{select_features}: Select Features? (type: logical, default: FALSE)
\item \code{adjust_deg_free}: Smoothness Adjustment (type: double, default:
1.0)
}
}

\subsection{Translation from parsnip to the original package (regression)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gen_additive_mod(adjust_deg_free = numeric(1), select_features = logical(1)) \%>\% 
  set_engine("mgcv") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## GAM Model Specification (regression)
## 
## Main Arguments:
##   select_features = logical(1)
##   adjust_deg_free = numeric(1)
## 
## Computational engine: mgcv 
## 
## Model fit template:
## mgcv::gam(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     select = logical(1), gamma = numeric(1))
}\if{html}{\out{</div>}}
}

\subsection{Translation from parsnip to the original package (classification)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gen_additive_mod(adjust_deg_free = numeric(1), select_features = logical(1)) \%>\% 
  set_engine("mgcv") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## GAM Model Specification (classification)
## 
## Main Arguments:
##   select_features = logical(1)
##   adjust_deg_free = numeric(1)
## 
## Computational engine: mgcv 
## 
## Model fit template:
## mgcv::gam(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     select = logical(1), gamma = numeric(1), family = stats::binomial(link = "logit"))
}\if{html}{\out{</div>}}
}

\subsection{Model fitting}{

This model should be used with a model formula so that smooth terms can
be specified. For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(mgcv)
gen_additive_mod() \%>\% 
  set_engine("mgcv") \%>\% 
  set_mode("regression") \%>\% 
  fit(mpg ~ wt + gear + cyl + s(disp, k = 10), data = mtcars)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## parsnip model object
## 
## 
## Family: gaussian 
## Link function: identity 
## 
## Formula:
## mpg ~ wt + gear + cyl + s(disp, k = 10)
## 
## Estimated degrees of freedom:
## 7.52  total = 11.52 
## 
## GCV score: 4.225228
}\if{html}{\out{</div>}}

The smoothness of the terms will need to be manually specified (e.g.,
using \code{s(x, df = 10)}) in the formula. Tuning can be accomplished using
the \code{adjust_deg_free} parameter.

However, when using a workflow, the best approach is to avoid using
\code{\link[workflows:add_formula]{workflows::add_formula()}} and use
\code{\link[workflows:add_variables]{workflows::add_variables()}} in
conjunction with a model formula:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{spec <- 
  gen_additive_mod() \%>\% 
  set_engine("mgcv") \%>\% 
  set_mode("regression")

workflow() \%>\% 
  add_variables(outcomes = c(mpg), predictors = c(wt, gear, cyl, disp)) \%>\% 
  add_model(spec, formula = mpg ~ wt + gear + cyl + s(disp, k = 10)) \%>\% 
  fit(data = mtcars) \%>\% 
  extract_fit_engine()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## 
## Family: gaussian 
## Link function: identity 
## 
## Formula:
## mpg ~ wt + gear + cyl + s(disp, k = 10)
## 
## Estimated degrees of freedom:
## 7.52  total = 11.52 
## 
## GCV score: 4.225228
}\if{html}{\out{</div>}}

The reason for this is that
\code{\link[workflows:add_formula]{workflows::add_formula()}} will try to
create the model matrix and fail to find/use \code{s()}.
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip
will convert factor columns to indicators.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.
}

\subsection{References}{
\itemize{
\item Ross, W. 2021. \href{https://noamross.github.io/gams-in-r-course/}{\emph{Generalized Additive Models in R: A Free, Interactive Course using mgcv}}
\item Wood, S. 2017. \emph{Generalized Additive Models: An Introduction with
R}. Chapman and Hall/CRC.
}
}
}
\keyword{internal}
