% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_based.R
\docType{methods}
\name{dongensMetric}
\alias{dongensMetric}
\alias{dongensMetric,Partition,Partition-method}
\title{Dongen's Metric}
\usage{
dongensMetric(p, q)

\S4method{dongensMetric}{Partition,Partition}(p, q)
}
\arguments{
\item{p}{The partition \eqn{P}}

\item{q}{The partition \eqn{Q}}
}
\description{
Compute Dongen's metric
\deqn{
2n - \sum_{C \in P} \max_{D \in Q} |C \cap D| - \sum_{D \in Q} \max_{C \in P} |C \cap D|
}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions
}}

\examples{
dongensMetric(new("Partition", c(0, 0, 0, 1, 1)), 
              new("Partition", c(0, 0, 1, 1, 1))) == 2
              
}
\references{
\insertRef{vanDongen2000}{partitionComparison}
}
\seealso{
\code{\link{projectionNumber}}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
