% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{randIndex}
\alias{randIndex}
\alias{randIndex,Partition,Partition-method}
\alias{randIndex,PairCoefficients,missing-method}
\title{Rand Index}
\usage{
randIndex(p, q)

\S4method{randIndex}{Partition,Partition}(p, q)

\S4method{randIndex}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the Rand index
\deqn{\frac{N_{11} + N_{00}}{N}}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
randIndex(new("Partition", c(0, 0, 0, 1, 1)), 
          new("Partition", c(0, 0, 1, 1, 1))) == 0.6

}
\references{
\insertRef{Rand1971}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
