% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorical.R
\name{categorical}
\alias{categorical}
\title{Categorical fly-visual model}
\usage{
categorical(vismodeldata)
}
\arguments{
\item{vismodeldata}{(required) quantum catch color data. Can be either the result
from \code{\link{vismodel}} or independently calculated data (in the form of a data frame
with four columns named 'u' ,'s', 'm', 'l', representing a tetrachromatic dipteran viewer).}
}
\value{
Object of class \code{colspace} consisting of the following columns:

\code{R7p, R7y, R8p, R8y}: the quantum catch data used to
 calculate the remaining variables.

\code{x, y}: cartesian coordinates in the categorical colour space.

\code{r.vec}: the r vector (saturation, distance from the center).

\code{category}: fly-colour category. One of \code{p-y-}, \code{p-y+}, \code{p+y-}, \code{p+y+}.
}
\description{
Applies the fly categorical colour vision model of Troje (1993)
}
\examples{
data(flowers)
vis.flowers <- vismodel(flowers, visual = "musca", achromatic = "md.r1")
cat.flowers <- colspace(vis.flowers, space = "categorical")
}
\references{
Troje N. (1993). Spectral categories in the learning behaviour
 of blowflies. Zeitschrift fur Naturforschung C, 48, 96-96.
}
\author{
Thomas White \email{thomas.white026@gmail.com}
}
\keyword{internal}
