% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexagon.R
\name{hexagon}
\alias{hexagon}
\title{Colour hexagon}
\usage{
hexagon(vismodeldata)
}
\arguments{
\item{vismodeldata}{(required) quantum catch color data. Can be either the result
from \code{\link{vismodel}} or independently calculated data (in the form of a data frame
with three columns named 's', 'm', 'l', representing a trichromatic viewer).}
}
\value{
A data frame of class \code{colspace} consisting of the following columns:

\code{s}, \code{m}, \code{l}: the quantum catch data used to calculate
 the remaining variables

\code{x}, \code{y}: cartesian coordinates in the colour hexagon.

\code{h.theta}: hue angle theta (in degrees), with 0-degrees at the 1200
 angle, increasing clockwise.

\code{r.vec}: the r vector (saturation, distance from the center).

\code{sec.fine}: fine 'hue sector', wherein the full hexagon is composed
 of 36 10-degree sectors, with 0-degrees at the 1200 angle.

\code{sec.coarse}: coarse 'hue sector', wherein the full hexagon is
 composed of five sectors: blue, bluegreen, green, uvgreen, uv, and uvblue.
}
\description{
Calculates coordinates and colorimetric variables that represent reflectance spectra
in the hymenopteran color hexagon.
}
\examples{
data(flowers)
vis.flowers <- vismodel(flowers,
  visual = "apis", qcatch = "Ei", relative = FALSE,
  vonkries = TRUE, achro = "l", bkg = "green"
)
flowers.hex <- colspace(vis.flowers, space = "hexagon")
}
\references{
Chittka L. (1992). The colour hexagon: a chromaticity diagram
   based on photoreceptor excitations as a generalized representation of
   colour opponency. Journal of Comparative Physiology A, 170(5), 533-543.

Chittka L, Shmida A, Troje N, Menzel R. (1994). Ultraviolet as a
   component of flower reflections, and the colour perception of Hymenoptera.
   Vision research, 34(11), 1489-1508.
}
\author{
Thomas White \email{thomas.white026@gmail.com}
}
\keyword{internal}
