% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_start_import_labels_task_run}
\alias{glue_start_import_labels_task_run}
\title{Enables you to provide additional labels (examples of truth) to be used
to teach the machine learning transform and improve its quality}
\usage{
glue_start_import_labels_task_run(TransformId, InputS3Path,
  ReplaceAllLabels)
}
\arguments{
\item{TransformId}{[required] The unique identifier of the machine learning transform.}

\item{InputS3Path}{[required] The Amazon Simple Storage Service (Amazon S3) path from where you import
the labels.}

\item{ReplaceAllLabels}{Indicates whether to overwrite your existing labels.}
}
\value{
A list with the following syntax:\preformatted{list(
  TaskRunId = "string"
)
}
}
\description{
Enables you to provide additional labels (examples of truth) to be used
to teach the machine learning transform and improve its quality. This
API operation is generally used as part of the active learning workflow
that starts with the
\code{\link[=glue_start_ml_labeling_set_generation_task_run]{start_ml_labeling_set_generation_task_run}}
call and that ultimately results in improving the quality of your
machine learning transform.

After the
\code{\link[=glue_start_ml_labeling_set_generation_task_run]{start_ml_labeling_set_generation_task_run}}
finishes, AWS Glue machine learning will have generated a series of
questions for humans to answer. (Answering these questions is often
called 'labeling' in the machine learning workflows). In the case of the
\code{FindMatches} transform, these questions are of the form, “What is the
correct way to group these rows together into groups composed entirely
of matching records?” After the labeling process is finished, users
upload their answers/labels with a call to
\code{\link[=glue_start_import_labels_task_run]{start_import_labels_task_run}}.
After
\code{\link[=glue_start_import_labels_task_run]{start_import_labels_task_run}}
finishes, all future runs of the machine learning transform use the new
and improved labels and perform a higher-quality transformation.

By default,
\code{\link[=glue_start_ml_labeling_set_generation_task_run]{start_ml_labeling_set_generation_task_run}}
continually learns from and combines all labels that you upload unless
you set \code{Replace} to true. If you set \code{Replace} to true,
\code{\link[=glue_start_import_labels_task_run]{start_import_labels_task_run}}
deletes and forgets all previously uploaded labels and learns only from
the exact set that you upload. Replacing labels can be helpful if you
realize that you previously uploaded incorrect labels, and you believe
that they are having a negative effect on your transform quality.

You can check on the status of your task run by calling the
\code{\link[=glue_get_ml_task_run]{get_ml_task_run}} operation.
}
\section{Request syntax}{
\preformatted{svc$start_import_labels_task_run(
  TransformId = "string",
  InputS3Path = "string",
  ReplaceAllLabels = TRUE|FALSE
)
}
}

\keyword{internal}
