% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticsearchservice_operations.R
\name{elasticsearchservice_describe_reserved_elasticsearch_instance_offerings}
\alias{elasticsearchservice_describe_reserved_elasticsearch_instance_offerings}
\title{Lists available reserved Elasticsearch instance offerings}
\usage{
elasticsearchservice_describe_reserved_elasticsearch_instance_offerings(
  ReservedElasticsearchInstanceOfferingId, MaxResults, NextToken)
}
\arguments{
\item{ReservedElasticsearchInstanceOfferingId}{The offering identifier filter value. Use this parameter to show only
the available offering that matches the specified reservation
identifier.}

\item{MaxResults}{Set this value to limit the number of results returned. If not
specified, defaults to 100.}

\item{NextToken}{NextToken should be sent in case if earlier API call produced result
containing NextToken. It is used for pagination.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  ReservedElasticsearchInstanceOfferings = list(
    list(
      ReservedElasticsearchInstanceOfferingId = "string",
      ElasticsearchInstanceType = "m3.medium.elasticsearch"|"m3.large.elasticsearch"|"m3.xlarge.elasticsearch"|"m3.2xlarge.elasticsearch"|"m4.large.elasticsearch"|"m4.xlarge.elasticsearch"|"m4.2xlarge.elasticsearch"|"m4.4xlarge.elasticsearch"|"m4.10xlarge.elasticsearch"|"m5.large.elasticsearch"|"m5.xlarge.elasticsearch"|"m5.2xlarge.elasticsearch"|"m5.4xlarge.elasticsearch"|"m5.12xlarge.elasticsearch"|"r5.large.elasticsearch"|"r5.xlarge.elasticsearch"|"r5.2xlarge.elasticsearch"|"r5.4xlarge.elasticsearch"|"r5.12xlarge.elasticsearch"|"c5.large.elasticsearch"|"c5.xlarge.elasticsearch"|"c5.2xlarge.elasticsearch"|"c5.4xlarge.elasticsearch"|"c5.9xlarge.elasticsearch"|"c5.18xlarge.elasticsearch"|"ultrawarm1.medium.elasticsearch"|"ultrawarm1.large.elasticsearch"|"t2.micro.elasticsearch"|"t2.small.elasticsearch"|"t2.medium.elasticsearch"|"r3.large.elasticsearch"|"r3.xlarge.elasticsearch"|"r3.2xlarge.elasticsearch"|"r3.4xlarge.elasticsearch"|"r3.8xlarge.elasticsearch"|"i2.xlarge.elasticsearch"|"i2.2xlarge.elasticsearch"|"d2.xlarge.elasticsearch"|"d2.2xlarge.elasticsearch"|"d2.4xlarge.elasticsearch"|"d2.8xlarge.elasticsearch"|"c4.large.elasticsearch"|"c4.xlarge.elasticsearch"|"c4.2xlarge.elasticsearch"|"c4.4xlarge.elasticsearch"|"c4.8xlarge.elasticsearch"|"r4.large.elasticsearch"|"r4.xlarge.elasticsearch"|"r4.2xlarge.elasticsearch"|"r4.4xlarge.elasticsearch"|"r4.8xlarge.elasticsearch"|"r4.16xlarge.elasticsearch"|"i3.large.elasticsearch"|"i3.xlarge.elasticsearch"|"i3.2xlarge.elasticsearch"|"i3.4xlarge.elasticsearch"|"i3.8xlarge.elasticsearch"|"i3.16xlarge.elasticsearch",
      Duration = 123,
      FixedPrice = 123.0,
      UsagePrice = 123.0,
      CurrencyCode = "string",
      PaymentOption = "ALL_UPFRONT"|"PARTIAL_UPFRONT"|"NO_UPFRONT",
      RecurringCharges = list(
        list(
          RecurringChargeAmount = 123.0,
          RecurringChargeFrequency = "string"
        )
      )
    )
  )
)
}
}
\description{
Lists available reserved Elasticsearch instance offerings.
}
\section{Request syntax}{
\preformatted{svc$describe_reserved_elasticsearch_instance_offerings(
  ReservedElasticsearchInstanceOfferingId = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
