% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticsearchservice_operations.R
\name{elasticsearchservice_update_elasticsearch_domain_config}
\alias{elasticsearchservice_update_elasticsearch_domain_config}
\title{Modifies the cluster configuration of the specified Elasticsearch
domain, setting as setting the instance type and the number of instances}
\usage{
elasticsearchservice_update_elasticsearch_domain_config(DomainName,
  ElasticsearchClusterConfig, EBSOptions, SnapshotOptions, VPCOptions,
  CognitoOptions, AdvancedOptions, AccessPolicies, LogPublishingOptions,
  DomainEndpointOptions, AdvancedSecurityOptions)
}
\arguments{
\item{DomainName}{[required] The name of the Elasticsearch domain that you are updating.}

\item{ElasticsearchClusterConfig}{The type and number of instances to instantiate for the domain cluster.}

\item{EBSOptions}{Specify the type and size of the EBS volume that you want to use.}

\item{SnapshotOptions}{Option to set the time, in UTC format, for the daily automated snapshot.
Default value is \code{0} hours.}

\item{VPCOptions}{Options to specify the subnets and security groups for VPC endpoint. For
more information, see \href{https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc}{Creating a VPC}
in \emph{VPC Endpoints for Amazon Elasticsearch Service Domains}}

\item{CognitoOptions}{Options to specify the Cognito user and identity pools for Kibana
authentication. For more information, see \href{https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html}{Amazon Cognito Authentication for Kibana}.}

\item{AdvancedOptions}{Modifies the advanced option to allow references to indices in an HTTP
request body. Must be \code{false} when configuring access to individual
sub-resources. By default, the value is \code{true}. See \href{https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options}{Configuration Advanced Options}
for more information.}

\item{AccessPolicies}{IAM access policy as a JSON-formatted string.}

\item{LogPublishingOptions}{Map of \code{LogType} and \code{LogPublishingOption}, each containing options to
publish a given type of Elasticsearch log.}

\item{DomainEndpointOptions}{Options to specify configuration that will be applied to the domain
endpoint.}

\item{AdvancedSecurityOptions}{Specifies advanced security options.}
}
\value{
A list with the following syntax:\preformatted{list(
  DomainConfig = list(
    ElasticsearchVersion = list(
      Options = "string",
      Status = list(
        CreationDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateVersion = 123,
        State = "RequiresIndexDocuments"|"Processing"|"Active",
        PendingDeletion = TRUE|FALSE
      )
    ),
    ElasticsearchClusterConfig = list(
      Options = list(
        InstanceType = "m3.medium.elasticsearch"|"m3.large.elasticsearch"|"m3.xlarge.elasticsearch"|"m3.2xlarge.elasticsearch"|"m4.large.elasticsearch"|"m4.xlarge.elasticsearch"|"m4.2xlarge.elasticsearch"|"m4.4xlarge.elasticsearch"|"m4.10xlarge.elasticsearch"|"m5.large.elasticsearch"|"m5.xlarge.elasticsearch"|"m5.2xlarge.elasticsearch"|"m5.4xlarge.elasticsearch"|"m5.12xlarge.elasticsearch"|"r5.large.elasticsearch"|"r5.xlarge.elasticsearch"|"r5.2xlarge.elasticsearch"|"r5.4xlarge.elasticsearch"|"r5.12xlarge.elasticsearch"|"c5.large.elasticsearch"|"c5.xlarge.elasticsearch"|"c5.2xlarge.elasticsearch"|"c5.4xlarge.elasticsearch"|"c5.9xlarge.elasticsearch"|"c5.18xlarge.elasticsearch"|"ultrawarm1.medium.elasticsearch"|"ultrawarm1.large.elasticsearch"|"t2.micro.elasticsearch"|"t2.small.elasticsearch"|"t2.medium.elasticsearch"|"r3.large.elasticsearch"|"r3.xlarge.elasticsearch"|"r3.2xlarge.elasticsearch"|"r3.4xlarge.elasticsearch"|"r3.8xlarge.elasticsearch"|"i2.xlarge.elasticsearch"|"i2.2xlarge.elasticsearch"|"d2.xlarge.elasticsearch"|"d2.2xlarge.elasticsearch"|"d2.4xlarge.elasticsearch"|"d2.8xlarge.elasticsearch"|"c4.large.elasticsearch"|"c4.xlarge.elasticsearch"|"c4.2xlarge.elasticsearch"|"c4.4xlarge.elasticsearch"|"c4.8xlarge.elasticsearch"|"r4.large.elasticsearch"|"r4.xlarge.elasticsearch"|"r4.2xlarge.elasticsearch"|"r4.4xlarge.elasticsearch"|"r4.8xlarge.elasticsearch"|"r4.16xlarge.elasticsearch"|"i3.large.elasticsearch"|"i3.xlarge.elasticsearch"|"i3.2xlarge.elasticsearch"|"i3.4xlarge.elasticsearch"|"i3.8xlarge.elasticsearch"|"i3.16xlarge.elasticsearch",
        InstanceCount = 123,
        DedicatedMasterEnabled = TRUE|FALSE,
        ZoneAwarenessEnabled = TRUE|FALSE,
        ZoneAwarenessConfig = list(
          AvailabilityZoneCount = 123
        ),
        DedicatedMasterType = "m3.medium.elasticsearch"|"m3.large.elasticsearch"|"m3.xlarge.elasticsearch"|"m3.2xlarge.elasticsearch"|"m4.large.elasticsearch"|"m4.xlarge.elasticsearch"|"m4.2xlarge.elasticsearch"|"m4.4xlarge.elasticsearch"|"m4.10xlarge.elasticsearch"|"m5.large.elasticsearch"|"m5.xlarge.elasticsearch"|"m5.2xlarge.elasticsearch"|"m5.4xlarge.elasticsearch"|"m5.12xlarge.elasticsearch"|"r5.large.elasticsearch"|"r5.xlarge.elasticsearch"|"r5.2xlarge.elasticsearch"|"r5.4xlarge.elasticsearch"|"r5.12xlarge.elasticsearch"|"c5.large.elasticsearch"|"c5.xlarge.elasticsearch"|"c5.2xlarge.elasticsearch"|"c5.4xlarge.elasticsearch"|"c5.9xlarge.elasticsearch"|"c5.18xlarge.elasticsearch"|"ultrawarm1.medium.elasticsearch"|"ultrawarm1.large.elasticsearch"|"t2.micro.elasticsearch"|"t2.small.elasticsearch"|"t2.medium.elasticsearch"|"r3.large.elasticsearch"|"r3.xlarge.elasticsearch"|"r3.2xlarge.elasticsearch"|"r3.4xlarge.elasticsearch"|"r3.8xlarge.elasticsearch"|"i2.xlarge.elasticsearch"|"i2.2xlarge.elasticsearch"|"d2.xlarge.elasticsearch"|"d2.2xlarge.elasticsearch"|"d2.4xlarge.elasticsearch"|"d2.8xlarge.elasticsearch"|"c4.large.elasticsearch"|"c4.xlarge.elasticsearch"|"c4.2xlarge.elasticsearch"|"c4.4xlarge.elasticsearch"|"c4.8xlarge.elasticsearch"|"r4.large.elasticsearch"|"r4.xlarge.elasticsearch"|"r4.2xlarge.elasticsearch"|"r4.4xlarge.elasticsearch"|"r4.8xlarge.elasticsearch"|"r4.16xlarge.elasticsearch"|"i3.large.elasticsearch"|"i3.xlarge.elasticsearch"|"i3.2xlarge.elasticsearch"|"i3.4xlarge.elasticsearch"|"i3.8xlarge.elasticsearch"|"i3.16xlarge.elasticsearch",
        DedicatedMasterCount = 123,
        WarmEnabled = TRUE|FALSE,
        WarmType = "ultrawarm1.medium.elasticsearch"|"ultrawarm1.large.elasticsearch",
        WarmCount = 123
      ),
      Status = list(
        CreationDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateVersion = 123,
        State = "RequiresIndexDocuments"|"Processing"|"Active",
        PendingDeletion = TRUE|FALSE
      )
    ),
    EBSOptions = list(
      Options = list(
        EBSEnabled = TRUE|FALSE,
        VolumeType = "standard"|"gp2"|"io1",
        VolumeSize = 123,
        Iops = 123
      ),
      Status = list(
        CreationDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateVersion = 123,
        State = "RequiresIndexDocuments"|"Processing"|"Active",
        PendingDeletion = TRUE|FALSE
      )
    ),
    AccessPolicies = list(
      Options = "string",
      Status = list(
        CreationDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateVersion = 123,
        State = "RequiresIndexDocuments"|"Processing"|"Active",
        PendingDeletion = TRUE|FALSE
      )
    ),
    SnapshotOptions = list(
      Options = list(
        AutomatedSnapshotStartHour = 123
      ),
      Status = list(
        CreationDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateVersion = 123,
        State = "RequiresIndexDocuments"|"Processing"|"Active",
        PendingDeletion = TRUE|FALSE
      )
    ),
    VPCOptions = list(
      Options = list(
        VPCId = "string",
        SubnetIds = list(
          "string"
        ),
        AvailabilityZones = list(
          "string"
        ),
        SecurityGroupIds = list(
          "string"
        )
      ),
      Status = list(
        CreationDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateVersion = 123,
        State = "RequiresIndexDocuments"|"Processing"|"Active",
        PendingDeletion = TRUE|FALSE
      )
    ),
    CognitoOptions = list(
      Options = list(
        Enabled = TRUE|FALSE,
        UserPoolId = "string",
        IdentityPoolId = "string",
        RoleArn = "string"
      ),
      Status = list(
        CreationDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateVersion = 123,
        State = "RequiresIndexDocuments"|"Processing"|"Active",
        PendingDeletion = TRUE|FALSE
      )
    ),
    EncryptionAtRestOptions = list(
      Options = list(
        Enabled = TRUE|FALSE,
        KmsKeyId = "string"
      ),
      Status = list(
        CreationDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateVersion = 123,
        State = "RequiresIndexDocuments"|"Processing"|"Active",
        PendingDeletion = TRUE|FALSE
      )
    ),
    NodeToNodeEncryptionOptions = list(
      Options = list(
        Enabled = TRUE|FALSE
      ),
      Status = list(
        CreationDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateVersion = 123,
        State = "RequiresIndexDocuments"|"Processing"|"Active",
        PendingDeletion = TRUE|FALSE
      )
    ),
    AdvancedOptions = list(
      Options = list(
        "string"
      ),
      Status = list(
        CreationDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateVersion = 123,
        State = "RequiresIndexDocuments"|"Processing"|"Active",
        PendingDeletion = TRUE|FALSE
      )
    ),
    LogPublishingOptions = list(
      Options = list(
        list(
          CloudWatchLogsLogGroupArn = "string",
          Enabled = TRUE|FALSE
        )
      ),
      Status = list(
        CreationDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateVersion = 123,
        State = "RequiresIndexDocuments"|"Processing"|"Active",
        PendingDeletion = TRUE|FALSE
      )
    ),
    DomainEndpointOptions = list(
      Options = list(
        EnforceHTTPS = TRUE|FALSE,
        TLSSecurityPolicy = "Policy-Min-TLS-1-0-2019-07"|"Policy-Min-TLS-1-2-2019-07",
        CustomEndpointEnabled = TRUE|FALSE,
        CustomEndpoint = "string",
        CustomEndpointCertificateArn = "string"
      ),
      Status = list(
        CreationDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateVersion = 123,
        State = "RequiresIndexDocuments"|"Processing"|"Active",
        PendingDeletion = TRUE|FALSE
      )
    ),
    AdvancedSecurityOptions = list(
      Options = list(
        Enabled = TRUE|FALSE,
        InternalUserDatabaseEnabled = TRUE|FALSE,
        SAMLOptions = list(
          Enabled = TRUE|FALSE,
          Idp = list(
            MetadataContent = "string",
            EntityId = "string"
          ),
          SubjectKey = "string",
          RolesKey = "string",
          SessionTimeoutMinutes = 123
        )
      ),
      Status = list(
        CreationDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateDate = as.POSIXct(
          "2015-01-01"
        ),
        UpdateVersion = 123,
        State = "RequiresIndexDocuments"|"Processing"|"Active",
        PendingDeletion = TRUE|FALSE
      )
    )
  )
)
}
}
\description{
Modifies the cluster configuration of the specified Elasticsearch
domain, setting as setting the instance type and the number of
instances.
}
\section{Request syntax}{
\preformatted{svc$update_elasticsearch_domain_config(
  DomainName = "string",
  ElasticsearchClusterConfig = list(
    InstanceType = "m3.medium.elasticsearch"|"m3.large.elasticsearch"|"m3.xlarge.elasticsearch"|"m3.2xlarge.elasticsearch"|"m4.large.elasticsearch"|"m4.xlarge.elasticsearch"|"m4.2xlarge.elasticsearch"|"m4.4xlarge.elasticsearch"|"m4.10xlarge.elasticsearch"|"m5.large.elasticsearch"|"m5.xlarge.elasticsearch"|"m5.2xlarge.elasticsearch"|"m5.4xlarge.elasticsearch"|"m5.12xlarge.elasticsearch"|"r5.large.elasticsearch"|"r5.xlarge.elasticsearch"|"r5.2xlarge.elasticsearch"|"r5.4xlarge.elasticsearch"|"r5.12xlarge.elasticsearch"|"c5.large.elasticsearch"|"c5.xlarge.elasticsearch"|"c5.2xlarge.elasticsearch"|"c5.4xlarge.elasticsearch"|"c5.9xlarge.elasticsearch"|"c5.18xlarge.elasticsearch"|"ultrawarm1.medium.elasticsearch"|"ultrawarm1.large.elasticsearch"|"t2.micro.elasticsearch"|"t2.small.elasticsearch"|"t2.medium.elasticsearch"|"r3.large.elasticsearch"|"r3.xlarge.elasticsearch"|"r3.2xlarge.elasticsearch"|"r3.4xlarge.elasticsearch"|"r3.8xlarge.elasticsearch"|"i2.xlarge.elasticsearch"|"i2.2xlarge.elasticsearch"|"d2.xlarge.elasticsearch"|"d2.2xlarge.elasticsearch"|"d2.4xlarge.elasticsearch"|"d2.8xlarge.elasticsearch"|"c4.large.elasticsearch"|"c4.xlarge.elasticsearch"|"c4.2xlarge.elasticsearch"|"c4.4xlarge.elasticsearch"|"c4.8xlarge.elasticsearch"|"r4.large.elasticsearch"|"r4.xlarge.elasticsearch"|"r4.2xlarge.elasticsearch"|"r4.4xlarge.elasticsearch"|"r4.8xlarge.elasticsearch"|"r4.16xlarge.elasticsearch"|"i3.large.elasticsearch"|"i3.xlarge.elasticsearch"|"i3.2xlarge.elasticsearch"|"i3.4xlarge.elasticsearch"|"i3.8xlarge.elasticsearch"|"i3.16xlarge.elasticsearch",
    InstanceCount = 123,
    DedicatedMasterEnabled = TRUE|FALSE,
    ZoneAwarenessEnabled = TRUE|FALSE,
    ZoneAwarenessConfig = list(
      AvailabilityZoneCount = 123
    ),
    DedicatedMasterType = "m3.medium.elasticsearch"|"m3.large.elasticsearch"|"m3.xlarge.elasticsearch"|"m3.2xlarge.elasticsearch"|"m4.large.elasticsearch"|"m4.xlarge.elasticsearch"|"m4.2xlarge.elasticsearch"|"m4.4xlarge.elasticsearch"|"m4.10xlarge.elasticsearch"|"m5.large.elasticsearch"|"m5.xlarge.elasticsearch"|"m5.2xlarge.elasticsearch"|"m5.4xlarge.elasticsearch"|"m5.12xlarge.elasticsearch"|"r5.large.elasticsearch"|"r5.xlarge.elasticsearch"|"r5.2xlarge.elasticsearch"|"r5.4xlarge.elasticsearch"|"r5.12xlarge.elasticsearch"|"c5.large.elasticsearch"|"c5.xlarge.elasticsearch"|"c5.2xlarge.elasticsearch"|"c5.4xlarge.elasticsearch"|"c5.9xlarge.elasticsearch"|"c5.18xlarge.elasticsearch"|"ultrawarm1.medium.elasticsearch"|"ultrawarm1.large.elasticsearch"|"t2.micro.elasticsearch"|"t2.small.elasticsearch"|"t2.medium.elasticsearch"|"r3.large.elasticsearch"|"r3.xlarge.elasticsearch"|"r3.2xlarge.elasticsearch"|"r3.4xlarge.elasticsearch"|"r3.8xlarge.elasticsearch"|"i2.xlarge.elasticsearch"|"i2.2xlarge.elasticsearch"|"d2.xlarge.elasticsearch"|"d2.2xlarge.elasticsearch"|"d2.4xlarge.elasticsearch"|"d2.8xlarge.elasticsearch"|"c4.large.elasticsearch"|"c4.xlarge.elasticsearch"|"c4.2xlarge.elasticsearch"|"c4.4xlarge.elasticsearch"|"c4.8xlarge.elasticsearch"|"r4.large.elasticsearch"|"r4.xlarge.elasticsearch"|"r4.2xlarge.elasticsearch"|"r4.4xlarge.elasticsearch"|"r4.8xlarge.elasticsearch"|"r4.16xlarge.elasticsearch"|"i3.large.elasticsearch"|"i3.xlarge.elasticsearch"|"i3.2xlarge.elasticsearch"|"i3.4xlarge.elasticsearch"|"i3.8xlarge.elasticsearch"|"i3.16xlarge.elasticsearch",
    DedicatedMasterCount = 123,
    WarmEnabled = TRUE|FALSE,
    WarmType = "ultrawarm1.medium.elasticsearch"|"ultrawarm1.large.elasticsearch",
    WarmCount = 123
  ),
  EBSOptions = list(
    EBSEnabled = TRUE|FALSE,
    VolumeType = "standard"|"gp2"|"io1",
    VolumeSize = 123,
    Iops = 123
  ),
  SnapshotOptions = list(
    AutomatedSnapshotStartHour = 123
  ),
  VPCOptions = list(
    SubnetIds = list(
      "string"
    ),
    SecurityGroupIds = list(
      "string"
    )
  ),
  CognitoOptions = list(
    Enabled = TRUE|FALSE,
    UserPoolId = "string",
    IdentityPoolId = "string",
    RoleArn = "string"
  ),
  AdvancedOptions = list(
    "string"
  ),
  AccessPolicies = "string",
  LogPublishingOptions = list(
    list(
      CloudWatchLogsLogGroupArn = "string",
      Enabled = TRUE|FALSE
    )
  ),
  DomainEndpointOptions = list(
    EnforceHTTPS = TRUE|FALSE,
    TLSSecurityPolicy = "Policy-Min-TLS-1-0-2019-07"|"Policy-Min-TLS-1-2-2019-07",
    CustomEndpointEnabled = TRUE|FALSE,
    CustomEndpoint = "string",
    CustomEndpointCertificateArn = "string"
  ),
  AdvancedSecurityOptions = list(
    Enabled = TRUE|FALSE,
    InternalUserDatabaseEnabled = TRUE|FALSE,
    MasterUserOptions = list(
      MasterUserARN = "string",
      MasterUserName = "string",
      MasterUserPassword = "string"
    ),
    SAMLOptions = list(
      Enabled = TRUE|FALSE,
      Idp = list(
        MetadataContent = "string",
        EntityId = "string"
      ),
      MasterUserName = "string",
      MasterBackendRole = "string",
      SubjectKey = "string",
      RolesKey = "string",
      SessionTimeoutMinutes = 123
    )
  )
)
}
}

\keyword{internal}
