% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mturk_operations.R
\name{mturk_list_reviewable_hi_ts}
\alias{mturk_list_reviewable_hi_ts}
\title{The ListReviewableHITs operation retrieves the HITs with Status equal to
Reviewable or Status equal to Reviewing that belong to the Requester
calling the operation}
\usage{
mturk_list_reviewable_hi_ts(HITTypeId, Status, NextToken, MaxResults)
}
\arguments{
\item{HITTypeId}{The ID of the HIT type of the HITs to consider for the query. If not
specified, all HITs for the Reviewer are considered}

\item{Status}{Can be either \code{Reviewable} or \code{Reviewing}. Reviewable is the default
value.}

\item{NextToken}{Pagination Token}

\item{MaxResults}{Limit the number of results returned.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  NumResults = 123,
  HITs = list(
    list(
      HITId = "string",
      HITTypeId = "string",
      HITGroupId = "string",
      HITLayoutId = "string",
      CreationTime = as.POSIXct(
        "2015-01-01"
      ),
      Title = "string",
      Description = "string",
      Question = "string",
      Keywords = "string",
      HITStatus = "Assignable"|"Unassignable"|"Reviewable"|"Reviewing"|"Disposed",
      MaxAssignments = 123,
      Reward = "string",
      AutoApprovalDelayInSeconds = 123,
      Expiration = as.POSIXct(
        "2015-01-01"
      ),
      AssignmentDurationInSeconds = 123,
      RequesterAnnotation = "string",
      QualificationRequirements = list(
        list(
          QualificationTypeId = "string",
          Comparator = "LessThan"|"LessThanOrEqualTo"|"GreaterThan"|"GreaterThanOrEqualTo"|"EqualTo"|"NotEqualTo"|"Exists"|"DoesNotExist"|"In"|"NotIn",
          IntegerValues = list(
            123
          ),
          LocaleValues = list(
            list(
              Country = "string",
              Subdivision = "string"
            )
          ),
          RequiredToPreview = TRUE|FALSE,
          ActionsGuarded = "Accept"|"PreviewAndAccept"|"DiscoverPreviewAndAccept"
        )
      ),
      HITReviewStatus = "NotReviewed"|"MarkedForReview"|"ReviewedAppropriate"|"ReviewedInappropriate",
      NumberOfAssignmentsPending = 123,
      NumberOfAssignmentsAvailable = 123,
      NumberOfAssignmentsCompleted = 123
    )
  )
)
}
}
\description{
The \code{\link[=mturk_list_reviewable_hi_ts]{list_reviewable_hi_ts}} operation
retrieves the HITs with Status equal to Reviewable or Status equal to
Reviewing that belong to the Requester calling the operation.
}
\section{Request syntax}{
\preformatted{svc$list_reviewable_hi_ts(
  HITTypeId = "string",
  Status = "Reviewable"|"Reviewing",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
