% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_delete_user_by_principal_id}
\alias{quicksight_delete_user_by_principal_id}
\title{Deletes a user identified by its principal ID}
\usage{
quicksight_delete_user_by_principal_id(PrincipalId, AwsAccountId,
  Namespace)
}
\arguments{
\item{PrincipalId}{[required] The principal ID of the user.}

\item{AwsAccountId}{[required] The ID for the AWS account that the user is in. Currently, you use the
ID for the AWS account that contains your Amazon QuickSight account.}

\item{Namespace}{[required] The namespace. Currently, you should set this to \code{default}.}
}
\description{
Deletes a user identified by its principal ID.
}
\details{
The permission resource is
\code{arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>&lt;user-name&gt; </i> }.

\strong{CLI Sample:}

\code{aws quicksight delete-user-by-principal-id --aws-account-id=111122223333 --namespace=default --principal-id=ABCDEFJA26JLI7EUUOEHS }
}
\section{Request syntax}{
\preformatted{svc$delete_user_by_principal_id(
  PrincipalId = "string",
  AwsAccountId = "string",
  Namespace = "string"
)
}
}

\keyword{internal}
