% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_tag_resource}
\alias{athena_tag_resource}
\title{Adds one or more tags to the resource, such as a workgroup}
\usage{
athena_tag_resource(ResourceARN, Tags)
}
\arguments{
\item{ResourceARN}{[required] Requests that one or more tags are added to the resource (such as a
workgroup) for the specified ARN.}

\item{Tags}{[required] One or more tags, separated by commas, to be added to the resource, such
as a workgroup.}
}
\description{
Adds one or more tags to the resource, such as a workgroup. A tag is a
label that you assign to an AWS Athena resource (a workgroup). Each tag
consists of a key and an optional value, both of which you define. Tags
enable you to categorize resources (workgroups) in Athena, for example,
by purpose, owner, or environment. Use a consistent set of tag keys to
make it easier to search and filter workgroups in your account. For best
practices, see \href{https://aws.amazon.com/answers/account-management/aws-tagging-strategies/}{AWS Tagging Strategies}.
The key length is from 1 (minimum) to 128 (maximum) Unicode characters
in UTF-8. The tag value length is from 0 (minimum) to 256 (maximum)
Unicode characters in UTF-8. You can use letters and numbers
representable in UTF-8, and the following characters: + - = . \\_ : / @.
Tag keys and values are case-sensitive. Tag keys must be unique per
resource. If you specify more than one, separate them by commas.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  ResourceARN = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
